; Dissassembly of CPC+ version of AMSDOS
;
; NOTE: In the main this ROM is the same as the CPC version
 
c000 defb &01, &00,&07, &00
c004 defw &c075							;; address of RSX command table

;; RSX function table
c006 c3b3c1    jp      $c1b3			;; "CPM ROM" - init function
c009 c3a9c1    jp      $c1a9			;; |CPM command
c00c c335cd    jp      $cd35			;; |DISC
c00f c35dce    jp      $ce5d			;; |GAME
c012 c35dce    jp      $ce5d			;; |JEUX
c015 c361cd    jp      $cd61			;; |TAPE
c018 c35dce    jp      $ce5d			;; |SPIEL
c01b c35dce    jp      $ce5d			;; |JUEGO
c01e c3d1ce    jp      $ced1			;; |A			
c021 c3d4ce    jp      $ced4			;; |B
c024 c3dbce    jp      $cedb			;; |DRIVE
c027 c3f5ce    jp      $cef5			;; |USER
c02a c325d5    jp      $d525			;; |DIR
c02d c381d5    jp      $d581			;; |ERA
c030 c3bbd5    jp      $d5bb			;; |REN

c033 c3d8ca    jp      $cad8			;; BIOS
c036 c306c7    jp      $c706			;; BIOS
c039 c381c5    jp      $c581			;; BIOS
c03c c366c6    jp      $c666			;; BIOS
c03f c34ec6    jp      $c64e			;; BIOS
c042 c352c6    jp      $c652			;; BIOS
c045 c392c7    jp      $c792			;; BIOS
c048 c330c6    jp      $c630			;; BIOS
c04b c303c6    jp      $c603			;; BIOS

c04e c35fc1    jp      $c15f
c051 c3d2c0    jp      $c0d2
c054 c380c3    jp      $c380			;; serial interface: init
c057 c3f8c2    jp      $c2f8
c05a c3d2c3    jp      $c3d2			;; serial interface: test for byte received (channel 0)
c05d c3eec3    jp      $c3ee			;; serial interface: read recieve byte (channel 0)
c060 c32cc4    jp      $c42c			;; serial interface: has transmitted data (channel 0)
c063 c33cc4    jp      $c43c			;; serial interface: transmit byte (channel 0)
c066 c3dac3    jp      $c3da			;; serial interface: test for byte received (channel 1)
c069 c3f6c3    jp      $c3f6			;; serial interface: read receive byte (channel 1)
c06c c331c4    jp      $c431			;; serial interface: has transmitted data (channel 1)
c06f c342c4    jp      $c442			;; serial interface: transmit byte (channel 1)
c072 c3d7cd    jp      $cdd7			;; display startup menu

;; RSX command table
c075:
defb "CPM RO","M"+&80
defb "CP","M"+&80
defb "DIS","C"+&80
defb "GAM","E"+&80
defb "JEU","X"+&80
defb "TAP","E"+&80
defb "SPIE","L"+&80
defb "JUEG","O"+&80
defb "A"+&80
defb "B"+&80
defb "DRIV","E"+&80
defb "USE","R"+&80
defb "DI","R"+&80
defb "ER","A"+&80
defb "RE","N"+&80
defb 1+&80
defb 2+&80
defb 3+&80
defb 4+&80
defb 5+&80
defb 6+&80
defb 7+&80
defb 8+&80
defb 9+&80
defb 0

c0b7 2a3900    ld      hl,($0039)
c0ba 223ead    ld      ($ad3e),hl
c0bd 3ec3      ld      a,$c3
c0bf 3233ad    ld      ($ad33),a
c0c2 af        xor     a
c0c3 3240ad    ld      ($ad40),a
c0c6 f3        di      
c0c7 d9        exx     
c0c8 ed433cad  ld      ($ad3c),bc
c0cc d9        exx     
c0cd 21f1c0    ld      hl,$c0f1
c0d0 181a      jr      $c0ec            ; (+$1a)
c0d2 2140ad    ld      hl,$ad40
c0d5 be        cp      (hl)
c0d6 c8        ret     z

c0d7 c5        push    bc
c0d8 46        ld      b,(hl)
c0d9 77        ld      (hl),a
c0da b7        or      a
c0db 78        ld      a,b
c0dc c1        pop     bc
c0dd 28e7      jr      z,$c0c6          ; (-$19)
c0df f3        di      
c0e0 08        ex      af,af'
c0e1 d9        exx     
c0e2 ed4b3cad  ld      bc,($ad3c)
c0e6 b7        or      a
c0e7 08        ex      af,af'
c0e8 d9        exx     
c0e9 2129c1    ld      hl,$c129
c0ec 2234ad    ld      ($ad34),hl
c0ef fb        ei      
c0f0 c9        ret     

c0f1 f3        di      
c0f2 08        ex      af,af'
c0f3 d9        exx     
c0f4 2238ad    ld      ($ad38),hl
c0f7 e1        pop     hl
c0f8 ed7336ad  ld      ($ad36),sp
c0fc 3100c0    ld      sp,$c000
c0ff d5        push    de
c100 c5        push    bc
c101 f5        push    af
c102 fde5      push    iy
c104 ed4b3cad  ld      bc,($ad3c)
c108 b7        or      a
c109 cd46c1    call    $c146
c10c f3        di      
c10d 08        ex      af,af'
c10e d9        exx     
c10f ed433cad  ld      ($ad3c),bc
c113 215ac1    ld      hl,$c15a
c116 223900    ld      ($0039),hl
c119 fde1      pop     iy
c11b f1        pop     af
c11c c1        pop     bc
c11d d1        pop     de
c11e 2a38ad    ld      hl,($ad38)
c121 08        ex      af,af'
c122 d9        exx     
c123 ed7b36ad  ld      sp,($ad36)
c127 fb        ei      
c128 c9        ret     

c129 f3        di      
c12a 08        ex      af,af'
c12b d9        exx     
c12c e1        pop     hl
c12d ed7336ad  ld      ($ad36),sp
c131 3100c0    ld      sp,$c000
c134 cd46c1    call    $c146
c137 f3        di      
c138 d9        exx     
c139 215ac1    ld      hl,$c15a
c13c 223900    ld      ($0039),hl
c13f d9        exx     
c140 ed7b36ad  ld      sp,($ad36)
c144 fb        ei      
c145 c9        ret     

c146 ed5b3ead  ld      de,($ad3e)
c14a ed533900  ld      ($0039),de
c14e fd2148ac  ld      iy,$ac48
c152 5e        ld      e,(hl)
c153 23        inc     hl
c154 56        ld      d,(hl)
c155 d5        push    de
c156 08        ex      af,af'
c157 d9        exx     
c158 fb        ei      
c159 c9        ret     

c15a cd33ad    call    $ad33
c15d 3800      jr      c,$c15f          ; (+$00)
c15f 223aad    ld      ($ad3a),hl
c162 e1        pop     hl
c163 e5        push    hl
c164 23        inc     hl
c165 23        inc     hl
c166 e3        ex      (sp),hl
c167 e5        push    hl
c168 2a3aad    ld      hl,($ad3a)
c16b c333ad    jp      $ad33

;;================================================================
c16e 215ac1    ld      hl,$c15a
c171 223900    ld      ($0039),hl


;; execute boot-block code
c174 eb        ex      de,hl
c175 e9        jp      (hl)					;; and execute
;;================================================================

c176 c3a9c1    jp      $c1a9				;; |CPM command
c179 c3b5c2    jp      $c2b5
c17c c3d8c2    jp      $c2d8
c17f c3bac2    jp      $c2ba
c182 c3bfc2    jp      $c2bf
c185 c3c9c2    jp      $c2c9
c188 c3cec2    jp      $c2ce
c18b c3d3c2    jp      $c2d3
c18e c3e0c2    jp      $c2e0
c191 c3e9c2    jp      $c2e9
c194 c324c5    jp      $c524
c197 c329c5    jp      $c529
c19a c31ac5    jp      $c51a
c19d c3eec2    jp      $c2ee
c1a0 c3f3c2    jp      $c2f3
c1a3 c3c4c2    jp      $c2c4
c1a6 c35ac5    jp      $c55a

;;=========================================================
;; |CPM function

c1a9 cd12b9    call    $b912			; firmware function: KL CURR ROM SELECTION
c1ac 4f        ld      c,a				; rom select address
c1ad 21d3c1    ld      hl,$c1d3			; function to execute
c1b0 c316bd    jp      $bd16			; firmware function: mc start program

;;=========================================================
;; if the disc ROM is rom 0, then the equivalent of CPM command
;; is executed;

;; start routine

c1b3 3806      jr      c,$c1bb          ; (+$06)

c1b5 cd12b9    call    $b912			; firmware function: KL CURR ROM SELECTION
c1b8 b7        or      a				; rom 0?
c1b9 2818      jr      z,$c1d3          ; 

c1bb fde5      push    iy
c1bd d5        push    de
c1be 1100fb    ld      de,$fb00
c1c1 19        add     hl,de
c1c2 e5        push    hl
c1c3 23        inc     hl
c1c4 e5        push    hl
c1c5 fde1      pop     iy
c1c7 cdddc5    call    $c5dd
c1ca cd00cd    call    $cd00
c1cd e1        pop     hl
c1ce d1        pop     de
c1cf fde1      pop     iy
c1d1 37        scf     
c1d2 c9        ret     

;;=========================================================================
;; boot CPM

c1d3 3100c0    ld      sp,$c000
c1d6 fd2148ac  ld      iy,$ac48

;; clear $ad33-$add8
c1da 1133ad    ld      de,$ad33
c1dd 01a500    ld      bc,$00a5
c1e0 cd15cb    call    $cb15				;; clear block

c1e3 2141ad    ld      hl,$ad41
c1e6 35        dec     (hl)

c1e7 3e81      ld      a,$81
c1e9 320300    ld      ($0003),a
c1ec af        xor     a
c1ed 320400    ld      ($0004),a

;; copy bios and sio functions to ram
c1f0 2133c0    ld      hl,$c033
c1f3 1180be    ld      de,$be80
c1f6 013f00    ld      bc,$003f
c1f9 edb0      ldir    

c1fb cdb7c0    call    $c0b7

c1fe cdddc5    call    $c5dd

;; load boot sector
c201 0e41      ld      c,$41			; sector id
c203 110000    ld      de,$0000			; track 0, drive 0
c206 210001    ld      hl,$0100			; load address
c209 cd66c6    call    $c666			; BIOS: READ SECTOR

c20c dca3c2    call    c,$c2a3			; if loaded ok, check data is different
c20f 300a      jr      nc,$c21b         ; if loaded ok and data is the same,
										; or failed to load, then report error

;; start execute sequence
c211 eb        ex      de,hl			; HL->DE
										; DE will be 0
c212 0176c1    ld      bc,$c176
c215 3133ad    ld      sp,$ad33
c218 c36ec1    jp      $c16e

;; display failed to load boot sector message
c21b 3e0f      ld      a,$0f
c21d cd1ecb    call    $cb1e
c220 18df      jr      $c201            ; try again

;;==========================================================================

c222 cd9ac8    call    $c89a
c225 cddbc8    call    $c8db
c228 014801    ld      bc,$0148
c22b 110000    ld      de,$0000
c22e e5        push    hl
c22f cd90c2    call    $c290			; load contiguous sectors
c232 e1        pop     hl
c233 dca3c2    call    c,$c2a3			; if loaded ok, check data is different
c236 3051      jr      nc,$c289			; or failed to load, then report error
c238 e5        push    hl
c239 23        inc     hl
c23a 5e        ld      e,(hl)
c23b 23        inc     hl
c23c 56        ld      d,(hl)
c23d 21a4fc    ld      hl,$fca4
c240 19        add     hl,de
c241 eb        ex      de,hl
c242 e1        pop     hl
c243 010002    ld      bc,$0200
c246 edb0      ldir    
c248 eb        ex      de,hl
c249 01490a    ld      bc,$0a49
c24c 110000    ld      de,$0000
c24f cd90c2    call    $c290			; load contiguous sectors
c252 3035      jr      nc,$c289			; if loaded ok and data is the same,
										; or failed to load, then report error    
c254 eb        ex      de,hl
c255 2100ea    ld      hl,$ea00
c258 19        add     hl,de
c259 e5        push    hl
c25a 2106f2    ld      hl,$f206
c25d 19        add     hl,de
c25e 3ec3      ld      a,$c3
c260 320500    ld      ($0005),a
c263 220600    ld      ($0006),hl
c266 320000    ld      ($0000),a
c269 210300    ld      hl,$0003
c26c 19        add     hl,de
c26d 220100    ld      ($0001),hl
c270 2176c1    ld      hl,$c176
c273 013300    ld      bc,$0033
c276 edb0      ldir    
c278 210400    ld      hl,$0004
c27b 7e        ld      a,(hl)
c27c e60f      and     $0f
c27e fe02      cp      $02
c280 3802      jr      c,$c284          ; (+$02)
c282 3600      ld      (hl),$00
c284 4e        ld      c,(hl)
c285 d1        pop     de
c286 c36ec1    jp      $c16e

;;-------------------------------------------------------------
;; display error
c289 3e0e      ld      a,$0e
c28b cd1ecb    call    $cb1e
c28e 1892      jr      $c222            ; (-$6e)

;;==============================================================
;; load contiguous sectors over one or more tracks
;; 
;; assumptions:
;;
;; - single sided
;; - VENDOR/SYSTEM format
;; - 512 bytes per sector
;;
;; entry:
;; B = number of sectors
;; C = starting sector ID
;; HL = load address
;; D = starting track, E = drive
c290 cd66c6    call    $c666
c293 d0        ret     nc

;; increment sector ID
c294 79        ld      a,c
c295 0c        inc     c
c296 fe49      cp      $49
c298 3803      jr      c,$c29d          ; (+$03)
;; test if ID exceeds ID of last sector on track

;; reset ID to ID of first sector on track
c29a 0e41      ld      c,$41
;; increment track
c29c 14        inc     d

;; add 512 to load address
c29d 24        inc     h
c29e 24        inc     h
c29f 10ef      djnz    $c290            ; (-$11)
c2a1 37        scf     
c2a2 c9        ret     

;;==============================================================
;; check 512 bytes
;; 
;; HL = address
;; return: 
;;  - carry set: data is different
;;  - carry clear: data is the same

c2a3 e5        push    hl
c2a4 010200    ld      bc,$0002

;; C = number of 256 byte blocks

;; get first byte
c2a7 7e        ld      a,(hl)

;; check 256 bytes
c2a8 be        cp      (hl)
c2a9 23        inc     hl
c2aa 37        scf     
c2ab 2006      jr      nz,$c2b3         ; (+$06)
c2ad 10f9      djnz    $c2a8            ; (-$07)

;; next block of 256 bytes
c2af 0d        dec     c
c2b0 20f6      jr      nz,$c2a8         ; (-$0a)

;; data is the same
c2b2 b7        or      a
c2b3 e1        pop     hl
c2b4 c9        ret     
;;===============================================================

c2b5 cd33ad    call    $ad33
c2b8 22c221    ld      ($21c2),hl
c2bb 7d        ld      a,l
c2bc c4181c    call    nz,$1c18
c2bf 2186c4    ld      hl,$c486
c2c2 1817      jr      $c2db            ; (+$17)
c2c4 218fc4    ld      hl,$c48f
c2c7 1812      jr      $c2db            ; (+$12)
c2c9 2198c4    ld      hl,$c498
c2cc 180d      jr      $c2db            ; (+$0d)
c2ce 21a1c4    ld      hl,$c4a1
c2d1 1808      jr      $c2db            ; (+$08)
c2d3 21b3c4    ld      hl,$c4b3
c2d6 1803      jr      $c2db            ; (+$03)
c2d8 2174c4    ld      hl,$c474
c2db cd33ad    call    $ad33
c2de 61        ld      h,c
c2df c4cd5f    call    nz,$5fcd
c2e2 c1        pop     bc
c2e3 1f        rra     
c2e4 c5        push    bc
c2e5 2189be    ld      hl,$be89
c2e8 c9        ret     

c2e9 cd33ad    call    $ad33
c2ec f0        ret     p

c2ed c4cd33    call    nz,$33cd
c2f0 ad        xor     l
c2f1 4c        ld      c,h
c2f2 c5        push    bc
c2f3 cd33ad    call    $ad33
c2f6 2ec5      ld      l,$c5
c2f8 32c5ad    ld      ($adc5),a
c2fb 018100    ld      bc,$0081
c2fe 1142ad    ld      de,$ad42
c301 edb0      ldir    
c303 2143ad    ld      hl,$ad43
c306 22c3ad    ld      ($adc3),hl
c309 c9        ret     

c30a 2141ad    ld      hl,$ad41
c30d 7e        ld      a,(hl)
c30e b7        or      a
c30f 2804      jr      z,$c315          ; (+$04)
c311 35        dec     (hl)
c312 cc81bb    call    z,$bb81
c315 cd09bb    call    $bb09
c318 dc0cbb    call    c,$bb0c
c31b 9f        sbc     a,a
c31c c9        ret     

c31d 2142ad    ld      hl,$ad42
c320 7e        ld      a,(hl)
c321 b7        or      a
c322 281b      jr      z,$c33f          ; (+$1b)
c324 cd09bb    call    $bb09
c327 300c      jr      nc,$c335         ; (+$0c)
c329 21c5ad    ld      hl,$adc5
c32c 34        inc     (hl)
c32d 35        dec     (hl)
c32e c0        ret     nz

c32f 2142ad    ld      hl,$ad42
c332 3600      ld      (hl),$00
c334 c9        ret     

c335 35        dec     (hl)
c336 2ac3ad    ld      hl,($adc3)
c339 7e        ld      a,(hl)
c33a 23        inc     hl
c33b 22c3ad    ld      ($adc3),hl
c33e c9        ret     

c33f 2141ad    ld      hl,$ad41
c342 7e        ld      a,(hl)
c343 b7        or      a
c344 c481bb    call    nz,$bb81
c347 3600      ld      (hl),$00
c349 c306bb    jp      $bb06
c34c 3e1a      ld      a,$1a
c34e c9        ret     

c34f 3eff      ld      a,$ff
c351 c9        ret     

c352 2141ad    ld      hl,$ad41
c355 7e        ld      a,(hl)
c356 b7        or      a
c357 cc84bb    call    z,$bb84
c35a 36ff      ld      (hl),$ff
c35c 79        ld      a,c
c35d cd5abb    call    $bb5a
c360 fe20      cp      $20
c362 d0        ret     nc

c363 cd78bb    call    $bb78
c366 cd87bb    call    $bb87
c369 d8        ret     c

c36a cd8abb    call    $bb8a
c36d c38dbb    jp      $bb8d
c370 cd2ebd    call    $bd2e
c373 3f        ccf     
c374 9f        sbc     a,a
c375 c9        ret     

c376 79        ld      a,c
c377 cd2bbd    call    $bd2b
c37a d8        ret     c

c37b cdcac4    call    $c4ca
c37e 18f6      jr      $c376            ; (-$0a)

;;====================================================================================
;; Serial interface 

;; IC's:
;; Intel 8253 Programmable Interval timer
;; Zilog Z80 DART

;; I/O ports:
;; fadc - Z80 DART channel 0 data
;; fadd - Z80 DART channel 0 control
;; fade - Z80 DART channel 1 data
;; fadf - Z80 DART channel 1 control
;; fbdc - 8253 channel 0 counter
;; fbdd - 8253 channel 1 counter
;; fbde - 8253 channel 2 counter
;; fbdf - 8253 control

;; memory locations used by serial functions:
;;
;; adc6 - Z80 DART's "write register 5" for channel 0
;; adc7 - Z80 DART's "write register 5" for channel 1

;;====================================================================================
;; serial interface: init
;;
;; entry:
;; HL = address of 12 byte buffer 
;;
;; 0 1 Z80 DART's "write register 4" for channel 0
;; 1 1 Z80 DART's "write register 5" for channel 0
;; 2 1 Z80 DART's "write register 3" for channel 0
;; 3 1 Z80 DART's "write register 4" for channel 1
;; 4 1 Z80 DART's "write register 5" for channel 1
;; 5 1 Z80 DART's "write register 3" for channel 1
;; 6 2 8253 channel 0 count
;; 8 2 8253 channel 1 count
;; 10 2 8253 channel 2 count
;;
;; exit:
;; BC, DE, HL corrupt
;;
;; notes:
;; - adc6 will hold the state of Z80 DART's "write register 5" for channel 0
;; - adc7 will hold the state of Z80 DART's "write register 5" for channel 1

c380 f3        di      

;;--------------------------------------------------------------------------------------
;; setup Z80 DART

c381 01ddfa    ld      bc,$fadd			;; Base I/O address for Z80 DART registers
c384 11c6ad    ld      de,$adc6			;; Base address of stored "write register 5" for channel 0 and 1
c387 cdb4c3    call    $c3b4			;; setup Z80 DART channel 0
c38a 03        inc     bc
c38b 03        inc     bc
c38c 13        inc     de				;; DE = $adc7
										;; BC = I/O address of Z80 DART channel 1
c38d cdb4c3    call    $c3b4			;; setup Z80 DART channel 1

;;--------------------------------------------------------------------------------------
;; setup 8253 Programmable Interval Timer

c390 3e36      ld      a,$36			;; %00110110
										;; - select channel 0
										;; - read/load LSB then MSB
										;; - mode 3
										;; - binary 16 bit

c392 1edc      ld      e,$dc			;; $dc (8253 channel 0)
c394 cda5c3    call    $c3a5			;; set channel 0 count, mode, and countdown mode

c397 3e76      ld      a,$76			;; %01110110
										;; - select channel 1
										;; - read/load LSB then MSB
										;; - mode 3
										;; - binary 16 bit

c399 1c        inc     e				;; E = $dd (8253 channel 1)
c39a cda5c3    call    $c3a5			;; set channel 1 count, mode and countdown mode

c39d 3eb6      ld      a,$b6			;; %10110110
										;; - select channel 2
										;; - read/load LSB then MSB
										;; - mode 3
										;; - binary 16 bit

c39f 1c        inc     e				;; E = $de (8253 channel 2)
c3a0 cda5c3    call    $c3a5			;; set channel 1 count, mode and countdown mode

c3a3 fb        ei      
c3a4 c9        ret     

;;=====================================================================
;; initialise 8253 channel
;;
;; entry conditions:
;; A = 8253 Control 
;; bit 7,6: channel number
;; bit 5,4: read/load
;; bit 3,2,1: mode number
;; bit 0: 
;; E = &dc (8253 channel 0), &dd (8253 channel 1) or &de (8253 channel 2) or $df (8253 channel 3)
;; HL = address of parameter buffer (control word followed by time constant)
;;
;; exit conditions:

c3a5 01dffb    ld      bc,$fbdf			;; I/O address of 8253 control
c3a8 ed79      out     (c),a			

c3aa 4b        ld      c,e				;; BC = I/O address for channel counter
c3ab 7e        ld      a,(hl)			
c3ac 23        inc     hl
c3ad ed79      out     (c),a			;; set low byte of count
c3af 7e        ld      a,(hl)
c3b0 23        inc     hl
c3b1 ed79      out     (c),a			;; set high byte of count
c3b3 c9        ret     

;;=====================================================================
;; BC = I/O address of channel's control register
;; HL = pointer to buffer containing: write register 4, write register 5 and write register 3 for channel

c3b4 3e18      ld      a,$18			;; "channel reset"
c3b6 ed79      out     (c),a			;; write to "write register 0" of Z80 DART channel

c3b8 3e04      ld      a,$04
c3ba ed79      out     (c),a			;; select "write register 4" of Z80 DART channel
c3bc 7e        ld      a,(hl)
c3bd 23        inc     hl
c3be ed79      out     (c),a			;; write to "write register 4" of Z80 DART channel

c3c0 3e05      ld      a,$05
c3c2 ed79      out     (c),a			; select "write register 5" of Z80 DART
c3c4 7e        ld      a,(hl)
c3c5 12        ld      (de),a			; store current value
c3c6 23        inc     hl
c3c7 ed79      out     (c),a			;; write to "write register 5" of Z80 DART channel

c3c9 3e03      ld      a,$03			; select "write register 3" of Z80 DART
c3cb ed79      out     (c),a
c3cd 7e        ld      a,(hl)
c3ce 23        inc     hl
c3cf ed79      out     (c),a			;; write to "write register 3" of Z80 DART channel
c3d1 c9        ret     

;;=====================================================================
;; serial interface: test for byte received through channel 0

c3d2 01ddfa    ld      bc,$fadd			
c3d5 21c6ad    ld      hl,$adc6
c3d8 1806      jr      $c3e0            ; (+$06)

;;=====================================================================
;; serial interface: test for byte received through channel 1

c3da 01dffa    ld      bc,$fadf
c3dd 21c7ad    ld      hl,$adc7

;;---------------------------------------------------------------------
;; BC = I/O address of channel's control register
;; HL = address of channels "write register 5" 

c3e0 ed78      in      a,(c)			; read "read register 0" of Z80 DART
c3e2 0f        rrca						; transfer bit 0 ("Rx character available")
c3e3 9f        sbc     a,a
c3e4 d8        ret     c

c3e5 cd1bc4    call    $c41b			; set DTR

c3e8 ed78      in      a,(c)			; read "read register 0" of Z80 DART
c3ea 0f        rrca						; transfer bit 0 ("Rx character available")
c3eb 9f        sbc     a,a
c3ec 1829      jr      $c417            ; clear DTR

;;=================================================================
;; serial interface: read received byte from channel 0
;;
;; exit:
;; A = received byte

c3ee 01ddfa    ld      bc,$fadd			; channel 0
c3f1 21c6ad    ld      hl,$adc6
c3f4 1806      jr      $c3fc            

;;=================================================================
;; serial interface: read received byte from channel 1

c3f6 01dffa    ld      bc,$fadf			; channel 1
c3f9 21c7ad    ld      hl,$adc7

;;-----------------------------------------------------------------
;; BC = I/O address of channel's control register
;; HL = address of channels "write register 5" 

c3fc ed78      in      a,(c)
c3fe 0f        rrca						; Rx character available
c3ff 3812      jr      c,$c413          

c401 cd1bc4    call    $c41b			; set DTR

c404 cdbcc4    call    $c4bc
c407 fe1a      cp      $1a
c409 280c      jr      z,$c417          ; clear DTR

c40b ed78      in      a,(c)
c40d 0f        rrca						; Rx character available
c40e 30f4      jr      nc,$c404    
     
c410 cd17c4    call    $c417			; clear DTR
c413 0b        dec     bc				; BC = I/O address of channel's data register
c414 ed78      in      a,(c)			; read data
c416 c9        ret     

;;========================================================================
;; clear DTR output
;; 
;; BC = I/O address of channel's control register
;; HL contains old state of Z80 DART's "write register 5"

c417 1e00      ld      e,$00
c419 1802      jr      $c41d            ; (+$02)

;;========================================================================
;; set DTR output
;;
;; BC = I/O address of channel's control register
;; HL contains old state of Z80 DART's "write register 5"

c41b 1e80      ld      e,$80

;;-------------------------------------------------------------------------------
;; set or clear DTR
;; 
;; entry:
;; E = OR value ($80 will set DTR, $00 will clear DTR)
;; BC = I/O address of channel's control register
;; HL = pointer to Z80 DART's "write register 5" data
;;
;; exit:
;; All registers preserved

c41d f3        di      
c41e f5        push    af

c41f 3e05      ld      a,$05			; select write register 5
c421 ed79      out     (c),a

c423 7e        ld      a,(hl)			; HL contains old state of this register
c424 e67f      and     $7f				; keep all bits but DTR
c426 b3        or      e				; combine with E which contains new state
c427 ed79      out     (c),a			; output

c429 f1        pop     af
c42a fb        ei      
c42b c9        ret     

;;============================================================
;; serial interface: test if possible to transmit for channel 0
;;
c42c 01ddfa    ld      bc,$fadd			; channel 0
c42f 1803      jr      $c434           

;;============================================================
;; serial interface: test if possible to transmit for channel 1
;;
c431 01dffa    ld      bc,$fadf			; channel 1

;;-------------------------------------------------------------
;; entry:
;; BC = I/O address of channel's control register
;; exit:
;; A = 0 if Tx buffer is empty
;; A <>0 if Tx buffer is full

c434 ed78      in      a,(c)
c436 e604      and     $04				; isolate "Tx buffer full" status
c438 c8        ret     z

;; Tx buffer full
c439 37        scf     
c43a 9f        sbc     a,a
c43b c9        ret     

;;============================================================
;; serial interface: transmit byte through channel 0
;;
;; C = data byte to transmit

c43c 79        ld      a,c
c43d 01ddfa    ld      bc,$fadd
c440 1804      jr      $c446            

;;============================================================
;; serial interface: transmit byte through channel 1
;;
;; C = data byte to transmit

c442 79        ld      a,c
c443 01dffa    ld      bc,$fadf

;;-------------------------------------------------------------
;; A = data byte to transmit
;; BC = I/O address of channel's control register

c446 f5        push    af
c447 cdcac4    call    $c4ca
c44a cd34c4    call    $c434			; Tx buffer empty?
c44d 30f8      jr      nc,$c447         

c44f f1        pop     af
c450 0b        dec     bc
c451 ed79      out     (c),a			; write data
c453 c9        ret     

;;=========================================================================

c454 21aac4    ld      hl,$c4aa
c457 1808      jr      $c461            ; (+$08)
c459 21b3c4    ld      hl,$c4b3
c45c 1803      jr      $c461            ; (+$03)
c45e 2198c4    ld      hl,$c498
c461 46        ld      b,(hl)
c462 23        inc     hl
c463 3a0300    ld      a,($0003)
c466 07        rlca    
c467 10fd      djnz    $c466            ; (-$03)
c469 e606      and     $06
c46b 1600      ld      d,$00
c46d 5f        ld      e,a
c46e 19        add     hl,de
c46f 5e        ld      e,(hl)
c470 23        inc     hl
c471 56        ld      d,(hl)
c472 eb        ex      de,hl
c473 e9        jp      (hl)
c474 01a7be    ld      bc,$bea7
c477 0a        ld      a,(bc)
c478 c354c4    jp      $c454
c47b b3        or      e
c47c be        cp      (hl)
c47d 01aabe    ld      bc,$beaa
c480 1d        dec     e
c481 c359c4    jp      $c459
c484 b6        or      (hl)
c485 be        cp      (hl)
c486 01b0be    ld      bc,$beb0
c489 52        ld      d,d
c48a c35ec4    jp      $c45e
c48d bc        cp      h
c48e be        cp      (hl)
c48f 03        inc     bc
c490 ad        xor     l
c491 be        cp      (hl)
c492 4f        ld      c,a
c493 c370c3    jp      $c370
c496 b9        cp      c
c497 be        cp      (hl)
c498 03        inc     bc
c499 b0        or      b
c49a be        cp      (hl)
c49b 52        ld      d,d
c49c c376c3    jp      $c376
c49f bc        cp      h
c4a0 be        cp      (hl)
c4a1 05        dec     b
c4a2 b0        or      b
c4a3 be        cp      (hl)
c4a4 51        ld      d,c
c4a5 c3bcbe    jp      $bebc
c4a8 52        ld      d,d
c4a9 c307a7    jp      $a707
c4ac be        cp      (hl)
c4ad 4f        ld      c,a
c4ae c3b3be    jp      $beb3
c4b1 0a        ld      a,(bc)
c4b2 c307aa    jp      $aa07
c4b5 be        cp      (hl)
c4b6 4c        ld      c,h
c4b7 c3b6be    jp      $beb6
c4ba 1d        dec     e
c4bb c3cdca    jp      $cacd
c4be c4fe13    call    nz,$13fe
c4c1 c0        ret     nz

;;=========================================================================

c4c2 e5        push    hl
c4c3 c5        push    bc
c4c4 cd1dc3    call    $c31d
c4c7 c1        pop     bc
c4c8 e1        pop     hl
c4c9 c9        ret     

;;=========================================================================

c4ca e5        push    hl
c4cb d5        push    de
c4cc c5        push    bc
c4cd cd0ac3    call    $c30a
c4d0 b7        or      a
c4d1 280f      jr      z,$c4e2          ; (+$0f)
c4d3 cd1dc3    call    $c31d
c4d6 fe03      cp      $03
c4d8 2008      jr      nz,$c4e2         ; (+$08)
c4da 3e0d      ld      a,$0d
c4dc cd51cb    call    $cb51
c4df c322c2    jp      $c222
c4e2 c1        pop     bc
c4e3 d1        pop     de
c4e4 e1        pop     hl
c4e5 c9        ret     

;;=========================================================================

c4e6 c7        rst     $00
c4e7 c7        rst     $00
c4e8 c7        rst     $00
c4e9 c7        rst     $00
c4ea c7        rst     $00
c4eb c7        rst     $00
c4ec c7        rst     $00
c4ed c7        rst     $00
c4ee c7        rst     $00
c4ef c7        rst     $00
c4f0 79        ld      a,c
c4f1 fe02      cp      $02
c4f3 210000    ld      hl,$0000
c4f6 d0        ret     nc

c4f7 7b        ld      a,e
c4f8 1f        rra     
c4f9 380f      jr      c,$c50a          ; (+$0f)
c4fb 59        ld      e,c
c4fc 3e18      ld      a,$18
c4fe cdc2ca    call    $cac2
c501 b7        or      a
c502 2006      jr      nz,$c50a         ; (+$06)
c504 e5        push    hl
c505 cd6cc5    call    $c56c
c508 e1        pop     hl
c509 d0        ret     nc

c50a 79        ld      a,c
c50b 3253be    ld      ($be53),a
c50e 211002    ld      hl,$0210
c511 b7        or      a
c512 2803      jr      z,$c517          ; (+$03)
c514 212002    ld      hl,$0220
c517 c305cb    jp      $cb05			;; HL = HL + IY
c51a ed4360be  ld      ($be60),bc
c51e c9        ret     

c51f cd9ac8    call    $c89a
c522 0e00      ld      c,$00
c524 79        ld      a,c
c525 3254be    ld      ($be54),a
c528 c9        ret     

c529 79        ld      a,c
c52a 3255be    ld      ($be55),a
c52d c9        ret     

c52e c5        push    bc
c52f 79        ld      a,c
c530 fe02      cp      $02
c532 cc17c8    call    z,$c817
c535 cd2cc8    call    $c82c
c538 dc47c8    call    c,$c847
c53b cd5dc8    call    $c85d
c53e c1        pop     bc
c53f d0        ret     nc

c540 cde1c8    call    $c8e1
c543 0d        dec     c
c544 37        scf     
c545 cc9ac8    call    z,$c89a
c548 d0        ret     nc

c549 3e00      ld      a,$00
c54b c9        ret     

c54c af        xor     a
c54d 3259be    ld      ($be59),a
c550 cd5dc8    call    $c85d
c553 cdf2c8    call    $c8f2
c556 d0        ret     nc

c557 3e00      ld      a,$00
c559 c9        ret     

c55a 60        ld      h,b
c55b 69        ld      l,c
c55c c9        ret     

c55d 017efb    ld      bc,$fb7e
c560 3e4a      ld      a,$4a
c562 cd88c9    call    $c988
c565 7b        ld      a,e
c566 cd88c9    call    $c988
c569 c324c9    jp      $c924
c56c cdccc9    call    $c9cc
c56f 3e16      ld      a,$16
c571 cdc2ca    call    $cac2
c574 57        ld      d,a
c575 0e10      ld      c,$10
c577 215dc5    ld      hl,$c55d
c57a cd29c7    call    $c729
c57d d0        ret     nc

c57e 3a51be    ld      a,($be51)
c581 f5        push    af
c582 af        xor     a
c583 cdc9ca    call    $cac9
c586 e5        push    hl
c587 eb        ex      de,hl
c588 21a9ca    ld      hl,$caa9
c58b 011600    ld      bc,$0016
c58e edb0      ldir    
c590 e1        pop     hl
c591 f1        pop     af
c592 e6c0      and     $c0
c594 fe40      cp      $40
c596 37        scf     
c597 c8        ret     z

c598 11cac5    ld      de,$c5ca
c59b fec0      cp      $c0
c59d 2803      jr      z,$c5a2          ; (+$03)
c59f 11c0c5    ld      de,$c5c0
c5a2 1a        ld      a,(de)
c5a3 13        inc     de
c5a4 77        ld      (hl),a
c5a5 23        inc     hl
c5a6 1a        ld      a,(de)
c5a7 13        inc     de
c5a8 77        ld      (hl),a
c5a9 010400    ld      bc,$0004
c5ac 09        add     hl,bc
c5ad 1a        ld      a,(de)
c5ae 13        inc     de
c5af 77        ld      (hl),a
c5b0 23        inc     hl
c5b1 1a        ld      a,(de)
c5b2 13        inc     de
c5b3 77        ld      (hl),a
c5b4 010700    ld      bc,$0007
c5b7 09        add     hl,bc
c5b8 eb        ex      de,hl
c5b9 010600    ld      bc,$0006
c5bc edb0      ldir    
c5be 37        scf     
c5bf c9        ret     

c5c0 2000      jr      nz,$c5c2         ; (+$00)
c5c2 9b        sbc     a,e
c5c3 00        nop     
c5c4 010001    ld      bc,$0100
c5c7 08        ex      af,af'
c5c8 2a5024    ld      hl,($2450)
c5cb 00        nop     
c5cc b3        or      e
c5cd 00        nop     
c5ce 00        nop     
c5cf 00        nop     
c5d0 c1        pop     bc
c5d1 09        add     hl,bc
c5d2 2a5232    ld      hl,($3252)
c5d5 00        nop     
c5d6 fa00af    jp      m,$af00
c5d9 0f        rrca    
c5da 0c        inc     c
c5db 0f        rrca    
c5dc 03        inc     bc

;;==========================================================

c5dd 1140be    ld      de,$be40
c5e0 013d00    ld      bc,$003d
c5e3 cd15cb    call    $cb15			;; clear block

c5e6 0d        dec     c				; C = $ff
c5e7 cd15b9    call    $b915			; firmware function: hi: kl probe rom
c5ea fe80      cp      $80				; built in ROM? e.g. BASIC
c5ec 2009      jr      nz,$c5f7          

;; test BASIC rom

;; L = rom's mark number 
;; H = rom's version number 

;; test for version 0, mark 1
c5ee 7d        ld      a,l				
c5ef 3d        dec     a				
c5f0 b4        or      h				
c5f1 2804      jr      z,$c5f7          

;; not version 0, mark 1

;; ensure firmare function: kl scan needed is called
;; before execution phase of disc command
c5f3 2179be    ld      hl,$be79
c5f6 35        dec     (hl)

;; detect if floppy disc controller is present 
c5f7 cda3c9    call    $c9a3

;; store fdc detected state (0=not detected, $ff = detected)
c5fa 9f        sbc     a,a
c5fb 327abe    ld      ($be7a),a

c5fe d0        ret     nc

;; will only get to here if fdc was detected

c5ff 180f      jr      $c610            ; (+$0f)

;;==========================================================
;; unused

c601 c7        rst     $00
c602 c7        rst     $00

;;==========================================================
;; BIOS: SET RETRY COUNT
;; 
;; entry:
;; A = new count
;;
;; exit:
;; A = previous count
;; 
c603 e5        push    hl
c604 2a66be    ld      hl,($be66)
c607 3266be    ld      ($be66),a
c60a 7d        ld      a,l
c60b e1        pop     hl
c60c c9        ret     

;;==========================================================
;; entry point for BIOS: SETUP DISC
;; 
;; entry:
;; HL = nine bytes making up parameter block

c60d c306c7    jp      $c706

;;==========================================================

c610 cd56ca    call    $ca56
c613 cd4aca    call    $ca4a
c616 21d4c5    ld      hl,$c5d4
c619 cd06c7    call    $c706
c61c cd12b9    call    $b912
c61f 4f        ld      c,a
c620 0680      ld      b,$80
c622 216dbe    ld      hl,$be6d
c625 1138ca    ld      de,$ca38
c628 cdefbc    call    $bcef
c62b 3e10      ld      a,$10
c62d 18d4      jr      $c603            ; (-$2c)

;;==================================================================
;; unused

c62f c7        rst     $00

;;==================================================================
;; BIOS: GET DRIVE STATUS
;;
;; entry:
;; A = drive number
;;
;; exit:
;; A = status byte

c630 cd37c6    call    $c637
c633 3a4cbe    ld      a,($be4c)
c636 c9        ret     

c637 cdccc9    call    $c9cc
c63a f5        push    af
c63b cd71c9    call    $c971
c63e 017efb    ld      bc,$fb7e
c641 3e04      ld      a,$04
c643 cd88c9    call    $c988
c646 f1        pop     af
c647 cd88c9    call    $c988
c64a c34ac9    jp      $c94a
c64d c7        rst     $00
c64e 3e45      ld      a,$45
c650 1802      jr      $c654            ; (+$02)
c652 3e4d      ld      a,$4d
c654 cdccc9    call    $c9cc
c657 0611      ld      b,$11
c659 cd6dc6    call    $c66d
c65c 3a48be    ld      a,($be48)
c65f 3d        dec     a
c660 03        inc     bc
c661 03        inc     bc
c662 03        inc     bc
c663 20fa      jr      nz,$c65f         ; (-$06)
c665 c9        ret     

c666 cdccc9    call    $c9cc
c669 3e66      ld      a,$66
c66b 0610      ld      b,$10
c66d 2262be    ld      ($be62),hl
c670 67        ld      h,a
c671 69        ld      l,c
c672 2274be    ld      ($be74),hl
c675 48        ld      c,b
c676 217cc6    ld      hl,$c67c
c679 c329c7    jp      $c729
c67c 2a74be    ld      hl,($be74)
c67f 017efb    ld      bc,$fb7e
c682 7c        ld      a,h
c683 cd88c9    call    $c988
c686 7b        ld      a,e
c687 cd88c9    call    $c988
c68a 7c        ld      a,h
c68b fe4d      cp      $4d
c68d 2016      jr      nz,$c6a5         ; (+$16)
c68f 3e14      ld      a,$14
c691 cd85c9    call    $c985
c694 3e10      ld      a,$10
c696 cd85c9    call    $c985
c699 3e12      ld      a,$12
c69b cd85c9    call    $c985
c69e 3e13      ld      a,$13
c6a0 cdc2ca    call    $cac2
c6a3 181c      jr      $c6c1            ; (+$1c)
c6a5 7a        ld      a,d
c6a6 cd88c9    call    $c988
c6a9 af        xor     a
c6aa cd88c9    call    $c988
c6ad 7d        ld      a,l
c6ae cd88c9    call    $c988
c6b1 3e14      ld      a,$14
c6b3 cd85c9    call    $c985
c6b6 7d        ld      a,l
c6b7 cd88c9    call    $c988
c6ba 3e11      ld      a,$11
c6bc cd85c9    call    $c985
c6bf 3eff      ld      a,$ff
c6c1 cdd8c6    call    $c6d8

c6c4 3a79be    ld      a,($be79)
c6c7 b7        or      a
c6c8 c42ab9    call    nz,$b92a			;; firmware function: kl scan needed

c6cb fb        ei      
c6cc cd35c9    call    $c935
c6cf d8        ret     c

c6d0 c0        ret     nz

c6d1 3a4dbe    ld      a,($be4d)
c6d4 87        add     a,a
c6d5 c8        ret     z

c6d6 af        xor     a
c6d7 c9        ret     

c6d8 f3        di      
c6d9 cd88c9    call    $c988
c6dc 7c        ld      a,h
c6dd 2a62be    ld      hl,($be62)
c6e0 fe66      cp      $66
c6e2 2018      jr      nz,$c6fc         ; (+$18)
c6e4 1806      jr      $c6ec            ; (+$06)
c6e6 0c        inc     c
c6e7 ed78      in      a,(c)
c6e9 77        ld      (hl),a
c6ea 0d        dec     c
c6eb 23        inc     hl
c6ec ed78      in      a,(c)
c6ee f2ecc6    jp      p,$c6ec
c6f1 e620      and     $20
c6f3 20f1      jr      nz,$c6e6         ; (-$0f)
c6f5 c9        ret     

c6f6 0c        inc     c
c6f7 7e        ld      a,(hl)
c6f8 ed79      out     (c),a
c6fa 0d        dec     c
c6fb 23        inc     hl
c6fc ed78      in      a,(c)
c6fe f2fcc6    jp      p,$c6fc
c701 e620      and     $20
c703 20f1      jr      nz,$c6f6         ; (-$0f)
c705 c9        ret     

;;==========================================================
;; continuation of BIOS: SETUP DISC

c706 1144be    ld      de,$be44
c709 010700    ld      bc,$0007
c70c edb0      ldir    
c70e 017efb    ld      bc,$fb7e
c711 3e03      ld      a,$03
c713 cd88c9    call    $c988
c716 3a4abe    ld      a,($be4a)
c719 3d        dec     a
c71a 07        rlca    
c71b 07        rlca    
c71c 07        rlca    
c71d 2f        cpl     
c71e e6f0      and     $f0
c720 b6        or      (hl)
c721 cd88c9    call    $c988
c724 23        inc     hl
c725 7e        ld      a,(hl)
c726 c388c9    jp      $c988
c729 3a66be    ld      a,($be66)
c72c 47        ld      b,a
c72d cd55c7    call    $c755
c730 d8        ret     c

c731 2819      jr      z,$c74c          ; (+$19)
c733 78        ld      a,b
c734 e604      and     $04
c736 2809      jr      z,$c741          ; (+$09)
c738 d5        push    de
c739 1627      ld      d,$27
c73b cd95c7    call    $c795
c73e d1        pop     de
c73f 18ec      jr      $c72d            ; (-$14)
c741 e5        push    hl
c742 3e17      ld      a,$17
c744 cdc9ca    call    $cac9
c747 3600      ld      (hl),$00
c749 e1        pop     hl
c74a 18e1      jr      $c72d            ; (-$1f)
c74c 79        ld      a,c
c74d c5        push    bc
c74e cde0ca    call    $cae0
c751 c1        pop     bc
c752 20d5      jr      nz,$c729         ; (-$2b)
c754 c9        ret     

c755 cd83c7    call    $c783
c758 d8        ret     c

c759 c8        ret     z

c75a cd71c9    call    $c971
c75d cd83c7    call    $c783
c760 d8        ret     c

c761 1803      jr      $c766            ; (+$03)
c763 c392c7    jp      $c792
c766 c8        ret     z

c767 7a        ld      a,d
c768 fe27      cp      $27
c76a 05        dec     b
c76b 300a      jr      nc,$c777         ; (+$0a)
c76d 04        inc     b
c76e 14        inc     d
c76f cd95c7    call    $c795
c772 15        dec     d
c773 cd83c7    call    $c783
c776 d8        ret     c

c777 c8        ret     z

c778 7a        ld      a,d
c779 b7        or      a
c77a 2002      jr      nz,$c77e         ; (+$02)
c77c 05        dec     b
c77d c9        ret     

c77e 15        dec     d
c77f cd95c7    call    $c795
c782 14        inc     d
c783 cd95c7    call    $c795
c786 e5        push    hl
c787 c5        push    bc
c788 cd1e00    call    $001e
c78b c1        pop     bc
c78c e1        pop     hl
c78d d8        ret     c

c78e 20f3      jr      nz,$c783         ; (-$0d)
c790 05        dec     b
c791 c9        ret     

c792 cdccc9    call    $c9cc
c795 e5        push    hl
c796 c5        push    bc
c797 3a66be    ld      a,($be66)
c79a 47        ld      b,a
c79b 3e16      ld      a,$16
c79d cdc9ca    call    $cac9
c7a0 23        inc     hl
c7a1 7e        ld      a,(hl)
c7a2 2b        dec     hl
c7a3 b7        or      a
c7a4 2017      jr      nz,$c7bd         ; (+$17)
c7a6 c5        push    bc
c7a7 017efb    ld      bc,$fb7e
c7aa 3e07      ld      a,$07
c7ac cd88c9    call    $c988
c7af 7b        ld      a,e
c7b0 cd88c9    call    $c988
c7b3 3e28      ld      a,$28
c7b5 cdf3c7    call    $c7f3
c7b8 3024      jr      nc,$c7de         ; (+$24)
c7ba 3600      ld      (hl),$00
c7bc c1        pop     bc
c7bd 23        inc     hl
c7be 3600      ld      (hl),$00
c7c0 2b        dec     hl
c7c1 7e        ld      a,(hl)
c7c2 92        sub     d
c7c3 2827      jr      z,$c7ec          ; (+$27)
c7c5 c5        push    bc
c7c6 017efb    ld      bc,$fb7e
c7c9 3e0f      ld      a,$0f
c7cb cd88c9    call    $c988
c7ce 7b        ld      a,e
c7cf cd88c9    call    $c988
c7d2 7a        ld      a,d
c7d3 cd88c9    call    $c988
c7d6 96        sub     (hl)
c7d7 3002      jr      nc,$c7db         ; (+$02)
c7d9 7e        ld      a,(hl)
c7da 92        sub     d
c7db cdf3c7    call    $c7f3
c7de c1        pop     bc
c7df 380b      jr      c,$c7ec          ; (+$0b)
c7e1 20c3      jr      nz,$c7a6         ; (-$3d)
c7e3 05        dec     b
c7e4 ca0fca    jp      z,$ca0f
c7e7 cd71c9    call    $c971
c7ea 18ba      jr      $c7a6            ; (-$46)
c7ec 72        ld      (hl),d
c7ed 23        inc     hl
c7ee 35        dec     (hl)
c7ef c1        pop     bc
c7f0 e1        pop     hl
c7f1 37        scf     
c7f2 c9        ret     

c7f3 f5        push    af
c7f4 3a4abe    ld      a,($be4a)
c7f7 cd0cc8    call    $c80c
c7fa f1        pop     af
c7fb 3d        dec     a
c7fc 20f5      jr      nz,$c7f3         ; (-$0b)
c7fe 3a49be    ld      a,($be49)
c801 cd0cc8    call    $c80c
c804 3e08      ld      a,$08
c806 cd88c9    call    $c988
c809 c324c9    jp      $c924
c80c f5        push    af
c80d 3ef6      ld      a,$f6
c80f 3d        dec     a
c810 20fd      jr      nz,$c80f         ; (-$03)
c812 f1        pop     af
c813 3d        dec     a
c814 20f6      jr      nz,$c80c         ; (-$0a)
c816 c9        ret     

c817 2153be    ld      hl,$be53
c81a 5e        ld      e,(hl)
c81b 3e03      ld      a,$03
c81d cdc2ca    call    $cac2
c820 3c        inc     a
c821 1159be    ld      de,$be59
c824 12        ld      (de),a
c825 13        inc     de
c826 010300    ld      bc,$0003
c829 edb0      ldir    
c82b c9        ret     

c82c 1159be    ld      de,$be59
c82f 1a        ld      a,(de)
c830 b7        or      a
c831 c8        ret     z

c832 13        inc     de
c833 2153be    ld      hl,$be53
c836 0603      ld      b,$03
c838 1a        ld      a,(de)
c839 ae        xor     (hl)
c83a 2006      jr      nz,$c842         ; (+$06)
c83c 13        inc     de
c83d 23        inc     hl
c83e 10f8      djnz    $c838            ; (-$08)
c840 37        scf     
c841 c9        ret     

c842 af        xor     a
c843 3259be    ld      ($be59),a
c846 c9        ret     

c847 f5        push    af
c848 2159be    ld      hl,$be59
c84b 35        dec     (hl)
c84c 23        inc     hl
c84d 5e        ld      e,(hl)
c84e 23        inc     hl
c84f 23        inc     hl
c850 34        inc     (hl)
c851 af        xor     a
c852 cdc2ca    call    $cac2
c855 96        sub     (hl)
c856 2003      jr      nz,$c85b         ; (+$03)
c858 77        ld      (hl),a
c859 2b        dec     hl
c85a 34        inc     (hl)
c85b f1        pop     af
c85c c9        ret     

c85d f5        push    af
c85e cd7fc8    call    $c87f
c861 3819      jr      c,$c87c          ; (+$19)
c863 cd9ac8    call    $c89a
c866 c1        pop     bc
c867 d0        ret     nc

c868 c5        push    bc
c869 cdabc8    call    $c8ab
c86c f1        pop     af
c86d 3806      jr      c,$c875          ; (+$06)
c86f cdcdc8    call    $c8cd
c872 cd66c6    call    $c666
c875 f5        push    af
c876 9f        sbc     a,a
c877 325ebe    ld      ($be5e),a
c87a f1        pop     af
c87b c9        ret     

c87c f1        pop     af
c87d 37        scf     
c87e c9        ret     

c87f 3a5ebe    ld      a,($be5e)
c882 b7        or      a
c883 c8        ret     z

c884 0153be    ld      bc,$be53
c887 2156be    ld      hl,$be56
c88a 5e        ld      e,(hl)
c88b 0a        ld      a,(bc)
c88c ae        xor     (hl)
c88d c0        ret     nz

c88e 03        inc     bc
c88f 23        inc     hl
c890 0a        ld      a,(bc)
c891 ae        xor     (hl)
c892 c0        ret     nz

c893 cdbdc8    call    $c8bd
c896 ae        xor     (hl)
c897 c0        ret     nz

c898 37        scf     
c899 c9        ret     

c89a 215ebe    ld      hl,$be5e
c89d 3600      ld      (hl),$00
c89f 2b        dec     hl
c8a0 7e        ld      a,(hl)
c8a1 b7        or      a
c8a2 37        scf     
c8a3 c8        ret     z

c8a4 34        inc     (hl)
c8a5 cdcdc8    call    $c8cd
c8a8 c34ec6    jp      $c64e
c8ab 2156be    ld      hl,$be56
c8ae 0153be    ld      bc,$be53
c8b1 0a        ld      a,(bc)
c8b2 77        ld      (hl),a
c8b3 5f        ld      e,a
c8b4 23        inc     hl
c8b5 03        inc     bc
c8b6 0a        ld      a,(bc)
c8b7 77        ld      (hl),a
c8b8 cdbdc8    call    $c8bd
c8bb 77        ld      (hl),a
c8bc c9        ret     

c8bd 03        inc     bc
c8be 23        inc     hl
c8bf 3e15      ld      a,$15
c8c1 cdc2ca    call    $cac2
c8c4 57        ld      d,a
c8c5 0a        ld      a,(bc)
c8c6 cb3a      srl     d
c8c8 d8        ret     c

c8c9 cb3f      srl     a
c8cb 18f9      jr      $c8c6            ; (-$07)
c8cd ed5b56be  ld      de,($be56)
c8d1 3e0f      ld      a,$0f
c8d3 cdc2ca    call    $cac2
c8d6 2158be    ld      hl,$be58
c8d9 86        add     a,(hl)
c8da 4f        ld      c,a
c8db 21b002    ld      hl,$02b0
c8de c305cb    jp      $cb05			;; HL = HL + IY
c8e1 e5        push    hl
c8e2 d5        push    de
c8e3 c5        push    bc
c8e4 f5        push    af
c8e5 3eff      ld      a,$ff
c8e7 325dbe    ld      ($be5d),a
c8ea cd01c9    call    $c901
c8ed cd1bb9    call    $b91b
c8f0 180a      jr      $c8fc            ; (+$0a)
c8f2 e5        push    hl
c8f3 d5        push    de
c8f4 c5        push    bc
c8f5 f5        push    af
c8f6 cd01c9    call    $c901
c8f9 eb        ex      de,hl
c8fa edb0      ldir    
c8fc f1        pop     af
c8fd c1        pop     bc
c8fe d1        pop     de
c8ff e1        pop     hl
c900 c9        ret     

c901 2153be    ld      hl,$be53
c904 5e        ld      e,(hl)
c905 3e15      ld      a,$15
c907 cdc2ca    call    $cac2
c90a 3d        dec     a
c90b 23        inc     hl
c90c 23        inc     hl
c90d a6        and     (hl)
c90e 118000    ld      de,$0080
c911 213002    ld      hl,$0230
c914 3c        inc     a
c915 19        add     hl,de
c916 3d        dec     a
c917 20fc      jr      nz,$c915         ; (-$04)
c919 eb        ex      de,hl
c91a cdfeca    call    $cafe
c91d 2a60be    ld      hl,($be60)
c920 018000    ld      bc,$0080
c923 c9        ret     

c924 cd4ac9    call    $c94a
c927 fe40      cp      $40
c929 d8        ret     c

c92a e60b      and     $0b
c92c ee08      xor     $08
c92e bb        cp      e
c92f 3e13      ld      a,$13
c931 280f      jr      z,$c942          ; (+$0f)
c933 bf        cp      a
c934 c9        ret     

c935 cd24c9    call    $c924
c938 d8        ret     c

c939 c0        ret     nz

c93a 3a4dbe    ld      a,($be4d)
c93d e602      and     $02
c93f c8        ret     z

c940 3e12      ld      a,$12
c942 cde0ca    call    $cae0
c945 d8        ret     c

c946 ca0fca    jp      z,$ca0f
c949 c9        ret     

;;========================================================

c94a e5        push    hl
c94b d5        push    de
c94c 1600      ld      d,$00
c94e 214cbe    ld      hl,$be4c			; buffer for result phase data
c951 e5        push    hl
c952 ed78      in      a,(c)
c954 fec0      cp      $c0
c956 38fa      jr      c,$c952          ; (-$06)
c958 0c        inc     c
c959 ed78      in      a,(c)
c95b 0d        dec     c
c95c 77        ld      (hl),a
c95d 23        inc     hl
c95e 14        inc     d
;; delay
c95f e3        ex      (sp),hl
c960 e3        ex      (sp),hl
c961 e3        ex      (sp),hl
c962 e3        ex      (sp),hl

c963 ed78      in      a,(c)
c965 e610      and     $10
c967 20e9      jr      nz,$c952         ; (-$17)
c969 e1        pop     hl
c96a 7e        ld      a,(hl)
c96b 2b        dec     hl
c96c 72        ld      (hl),d
c96d d1        pop     de
c96e e1        pop     hl
c96f 37        scf     
c970 c9        ret     

;;========================================================
;; clear fdc interrupt

c971 c5        push    bc
c972 017efb    ld      bc,$fb7e
c975 3e08      ld      a,$08
c977 cd88c9    call    $c988
c97a cd4ac9    call    $c94a
c97d e6c0      and     $c0
c97f fe80      cp      $80
c981 20f2      jr      nz,$c975         ; (-$0e)
c983 c1        pop     bc
c984 c9        ret     

;;=======================================================
c985 cdc2ca    call    $cac2

;;========================================================
;; fdc: send command byte
;;
;; BC = I/O address of FDC main status register
;; A = command byte

c988 d5        push    de
c989 c5        push    bc
c98a f5        push    af
c98b 5f        ld      e,a

;; was fdc detected?
c98c 3a7abe    ld      a,($be7a)
c98f b7        or      a
c990 280d      jr      z,$c99f          

;; fdc was detected

;; test fdc is ready to accept command byte..
c992 ed78      in      a,(c)			; read FDC main status register
c994 87        add     a,a				; transfer bit 7 ("data ready") to carry
c995 30fb      jr      nc,$c992         
;; test data direction is from cpu to fdc...

c997 87        add     a,a				; transfer bit 6 ("data direction") to carry
c998 3805      jr      c,$c99f          

;; fdc is ready to accept command byte...

c99a 0c        inc     c				; BC = I/O address of FDC data register
c99b ed59      out     (c),e			; write command byte
;; delay
c99d e3        ex      (sp),hl
c99e e3        ex      (sp),hl

c99f f1        pop     af
c9a0 c1        pop     bc
c9a1 d1        pop     de
c9a2 c9        ret     

;;=====================================================================================
;; detect if floppy disc controller is present
;;
;; carry flag set if fdc is detected
;; carry flag clear if fdc is not detected
 
c9a3 017efb    ld      bc,$fb7e			; BC = I/O address of FDC main status register

c9a6 1e00      ld      e,$00			; initial retry count

;;--------------------------------------------------------------------------------------
;; check that fdc is ready to accept a command
;;
;; the fdc must be ready to accept a command within 256 reads of the main status register

c9a8 b7        or      a
c9a9 1d        dec     e				; decrement retry count
c9aa c8        ret     z				; quit if fdc was not ready 

c9ab ed78      in      a,(c)			; read main status register
c9ad e6c0      and     $c0				; isolate data direction and data ready status flags

c9af ee80      xor     $80				; test the conditions 1) data direction: cpu->fdc, 2) fdc ready to accept data
c9b1 20f5      jr      nz,$c9a8			; loop if conditions were not correct...

;; to get here, data direction must be from cpu to fdc
;; and fdc must be ready to accept data

c9b3 0c        inc     c				; BC = FDC data register
c9b4 ed79      out     (c),a			; write command byte (0 = "invalid")
c9b6 0d        dec     c				; BC = FDC main status register

;; delay 
c9b7 e3        ex      (sp),hl
c9b8 e3        ex      (sp),hl
c9b9 e3        ex      (sp),hl
c9ba e3        ex      (sp),hl

;; initialise retry count with 0
c9bb 5f        ld      e,a

;; check for start of result phase
;;
;; the result phase must activate within 256 reads of the main status register

c9bc 1d        dec     e				; decrement retry count
c9bd c8        ret     z				; quit if fdc was not ready

c9be ed78      in      a,(c)			; read main status register
c9c0 fec0      cp      $c0				; test the conditions 1) data direction: fdc->cpu 2) fdc has data ready
c9c2 38f8      jr      c,$c9bc          ; loop if conditions were not correct...

;; to get here, the result phase must be active

c9c4 0c        inc     c				; BC = FDC data register
c9c5 ed78      in      a,(c)			; read data
c9c7 ee80      xor     $80				; is data=&80? (&80 = status for invalid command)
c9c9 c0        ret     nz				; quit if wrong result was returned..

;; fdc was detected, fdc processed "invalid" command, and returned the correct results.

c9ca 37        scf     
c9cb c9        ret     
;;=====================================================================================

c9cc f5        push    af

;; was fdc detected?
c9cd 3a7abe    ld      a,($be7a)
c9d0 b7        or      a
c9d1 2004      jr      nz,$c9d7         ; (+$04)

;; fdc not detected
c9d3 f1        pop     af
c9d4 f1        pop     af
c9d5 af        xor     a
c9d6 c9        ret     

;;--------------------------------------------------------------------------------------
;; fdc was detected

c9d7 f1        pop     af
c9d8 2276be    ld      ($be76),hl
c9db e3        ex      (sp),hl
c9dc d5        push    de
c9dd c5        push    bc
c9de ed7364be  ld      ($be64),sp
c9e2 e5        push    hl
c9e3 210fca    ld      hl,$ca0f
c9e6 e3        ex      (sp),hl
c9e7 e5        push    hl
c9e8 d5        push    de
c9e9 c5        push    bc
c9ea f5        push    af
c9eb cd41ca    call    $ca41
c9ee 3a5fbe    ld      a,($be5f)
c9f1 b7        or      a
c9f2 2014      jr      nz,$ca08         ; (+$14)
c9f4 017efa    ld      bc,$fa7e
c9f7 3e01      ld      a,$01
c9f9 ed79      out     (c),a
c9fb ed5b44be  ld      de,($be44)
c9ff cd2fca    call    $ca2f
ca02 3a5fbe    ld      a,($be5f)
ca05 b7        or      a
ca06 28fa      jr      z,$ca02          ; (-$06)
ca08 f1        pop     af
ca09 c1        pop     bc
ca0a d1        pop     de
ca0b 2a76be    ld      hl,($be76)
ca0e c9        ret     

ca0f ed7b64be  ld      sp,($be64)
ca13 f5        push    af
ca14 ed5b46be  ld      de,($be46)
ca18 cd2fca    call    $ca2f
ca1b f1        pop     af
ca1c c1        pop     bc
ca1d d1        pop     de
ca1e e1        pop     hl
ca1f 3e00      ld      a,$00
ca21 d8        ret     c

ca22 214cbe    ld      hl,$be4c
ca25 7e        ld      a,(hl)
ca26 e608      and     $08
ca28 23        inc     hl
ca29 b6        or      (hl)
ca2a f640      or      $40
ca2c 2b        dec     hl
ca2d 2b        dec     hl
ca2e c9        ret     

ca2f 2167be    ld      hl,$be67
ca32 010000    ld      bc,$0000
ca35 c3e9bc    jp      $bce9
ca38 215fbe    ld      hl,$be5f
ca3b 7e        ld      a,(hl)
ca3c 2f        cpl     
ca3d 77        ld      (hl),a
ca3e b7        or      a
ca3f 2806      jr      z,$ca47          ; (+$06)
ca41 2167be    ld      hl,$be67
ca44 c3ecbc    jp      $bcec
ca47 cd41ca    call    $ca41
ca4a 3e00      ld      a,$00
ca4c 017efa    ld      bc,$fa7e
ca4f ed79      out     (c),a
ca51 af        xor     a
ca52 325fbe    ld      ($be5f),a
ca55 c9        ret     

ca56 212002    ld      hl,$0220
ca59 11d001    ld      de,$01d0
ca5c cd65ca    call    $ca65
ca5f 211002    ld      hl,$0210
ca62 119001    ld      de,$0190
ca65 cdfeca    call    $cafe
ca68 ed5342be  ld      ($be42),de
ca6c d5        push    de
ca6d cd05cb    call    $cb05			
ca70 1803      jr      $ca75            ; (+$03)
ca72 c3d8ca    jp      $cad8
ca75 2240be    ld      ($be40),hl
ca78 e5        push    hl
ca79 21a9ca    ld      hl,$caa9
ca7c 011900    ld      bc,$0019
ca7f edb0      ldir    
ca81 4b        ld      c,e
ca82 42        ld      b,d
ca83 e1        pop     hl
ca84 af        xor     a
ca85 77        ld      (hl),a
ca86 23        inc     hl
ca87 77        ld      (hl),a
ca88 110700    ld      de,$0007
ca8b 19        add     hl,de
ca8c 113002    ld      de,$0230
ca8f cdfeca    call    $cafe
ca92 73        ld      (hl),e
ca93 23        inc     hl
ca94 72        ld      (hl),d
ca95 23        inc     hl
ca96 d1        pop     de
ca97 73        ld      (hl),e
ca98 23        inc     hl
ca99 72        ld      (hl),d
ca9a 23        inc     hl
ca9b 71        ld      (hl),c
ca9c 23        inc     hl
ca9d 70        ld      (hl),b
ca9e 23        inc     hl
ca9f eb        ex      de,hl
caa0 211000    ld      hl,$0010
caa3 09        add     hl,bc
caa4 eb        ex      de,hl
caa5 73        ld      (hl),e
caa6 23        inc     hl
caa7 72        ld      (hl),d
caa8 c9        ret     

caa9 24        inc     h
caaa 00        nop     
caab 03        inc     bc
caac 07        rlca    
caad 00        nop     
caae aa        xor     d
caaf 00        nop     
cab0 3f        ccf     
cab1 00        nop     
cab2 c0        ret     nz

cab3 00        nop     
cab4 1000      djnz    $cab6            ; (+$00)
cab6 02        ld      (bc),a
cab7 00        nop     
cab8 41        ld      b,c
cab9 09        add     hl,bc
caba 2a52e5    ld      hl,($e552)
cabd 02        ld      (bc),a
cabe 04        inc     b
cabf 00        nop     
cac0 00        nop     
cac1 00        nop     
cac2 e5        push    hl
cac3 cdc9ca    call    $cac9
cac6 7e        ld      a,(hl)
cac7 e1        pop     hl
cac8 c9        ret     

cac9 d5        push    de
caca 2a42be    ld      hl,($be42)
cacd 1d        dec     e
cace 114000    ld      de,$0040
cad1 2001      jr      nz,$cad4         ; (+$01)
cad3 19        add     hl,de
cad4 5f        ld      e,a
cad5 19        add     hl,de
cad6 d1        pop     de
cad7 c9        ret     

cad8 2a78be    ld      hl,($be78)
cadb 3278be    ld      ($be78),a
cade 7d        ld      a,l
cadf c9        ret     

cae0 f5        push    af
cae1 3a78be    ld      a,($be78)
cae4 b7        or      a
cae5 2005      jr      nz,$caec         ; (+$05)
cae7 f1        pop     af
cae8 4b        ld      c,e
cae9 c31ecb    jp      $cb1e
caec f1        pop     af
caed af        xor     a
caee c9        ret     

caef c7        rst     $00
caf0 c7        rst     $00
caf1 c7        rst     $00
caf2 c7        rst     $00
caf3 c7        rst     $00
caf4 c7        rst     $00
caf5 c7        rst     $00
caf6 fde5      push    iy
caf8 e3        ex      (sp),hl
caf9 09        add     hl,bc
cafa 44        ld      b,h
cafb 4d        ld      c,l
cafc e1        pop     hl
cafd c9        ret     

;;========================================================================
cafe fde5      push    iy
cb00 e3        ex      (sp),hl
cb01 19        add     hl,de
cb02 eb        ex      de,hl
cb03 e1        pop     hl
cb04 c9        ret     

;;========================================================================
;; HL = HL + IY
cb05 d5        push    de
cb06 fde5      push    iy
cb08 d1        pop     de
cb09 19        add     hl,de
cb0a d1        pop     de
cb0b c9        ret     


;;=======================================================================
;; convert to upper case
cb0c fe61      cp      $61
cb0e d8        ret     c

cb0f fe7b      cp      $7b
cb11 d0        ret     nc

cb12 c6e0      add     a,$e0
cb14 c9        ret     

;;===========================================================
;; clear ram block
;; DE = start
;; BC = length
cb15 af        xor     a
cb16 12        ld      (de),a
cb17 13        inc     de
cb18 0b        dec     bc
cb19 78        ld      a,b
cb1a b1        or      c
cb1b 20f8      jr      nz,$cb15         ; (-$08)
cb1d c9        ret     
;;===========================================================

cb1e cd51cb    call    $cb51
cb21 3e14      ld      a,$14
cb23 cd51cb    call    $cb51
cb26 cd09bb    call    $bb09
cb29 38fb      jr      c,$cb26          ; (-$05)
cb2b cd81bb    call    $bb81
cb2e cd06bb    call    $bb06
cb31 cd0ccb    call    $cb0c			; convert to upper case
cb34 fe43      cp      $43
cb36 2811      jr      z,$cb49          ; (+$11)
cb38 fe49      cp      $49
cb3a 37        scf     
cb3b 280c      jr      z,$cb49          ; (+$0c)
cb3d fe52      cp      $52
cb3f 2807      jr      z,$cb48          ; (+$07)
cb41 3e07      ld      a,$07
cb43 cd5abb    call    $bb5a
cb46 18e6      jr      $cb2e            ; (-$1a)
cb48 b7        or      a
cb49 cd5abb    call    $bb5a
cb4c cd84bb    call    $bb84
cb4f 3e00      ld      a,$00
cb51 e5        push    hl
cb52 c5        push    bc
cb53 f5        push    af
cb54 e67f      and     $7f
cb56 21eccb    ld      hl,$cbec
cb59 47        ld      b,a
cb5a 04        inc     b
cb5b 1805      jr      $cb62            ; (+$05)
cb5d 7e        ld      a,(hl)
cb5e 23        inc     hl
cb5f 3c        inc     a
cb60 20fb      jr      nz,$cb5d         ; (-$05)
cb62 10f9      djnz    $cb5d            ; (-$07)
cb64 7e        ld      a,(hl)
cb65 23        inc     hl
cb66 feff      cp      $ff
cb68 280b      jr      z,$cb75          ; (+$0b)
cb6a e5        push    hl
cb6b d5        push    de
cb6c c5        push    bc
cb6d cd79cb    call    $cb79
cb70 c1        pop     bc
cb71 d1        pop     de
cb72 e1        pop     hl
cb73 18ef      jr      $cb64            ; (-$11)
cb75 f1        pop     af
cb76 c1        pop     bc
cb77 e1        pop     hl
cb78 c9        ret     

cb79 b7        or      a
cb7a f2cccb    jp      p,$cbcc
cb7d fefe      cp      $fe
cb7f 2846      jr      z,$cbc7          ; (+$46)
cb81 fefc      cp      $fc
cb83 281a      jr      z,$cb9f          ; (+$1a)
cb85 fefd      cp      $fd
cb87 20c8      jr      nz,$cb51         ; (-$38)
cb89 0608      ld      b,$08
cb8b cd95cb    call    $cb95
cb8e 3e2e      ld      a,$2e
cb90 cde9cb    call    $cbe9
cb93 0603      ld      b,$03
cb95 13        inc     de
cb96 1a        ld      a,(de)
cb97 e67f      and     $7f
cb99 cde9cb    call    $cbe9
cb9c 10f7      djnz    $cb95            ; (-$09)
cb9e c9        ret     

cb9f eb        ex      de,hl
cba0 1620      ld      d,$20
cba2 019cff    ld      bc,$ff9c
cba5 cdb3cb    call    $cbb3
cba8 01f6ff    ld      bc,$fff6
cbab cdb3cb    call    $cbb3
cbae 7d        ld      a,l
cbaf c630      add     a,$30
cbb1 1836      jr      $cbe9            ; (+$36)
cbb3 3eff      ld      a,$ff
cbb5 e5        push    hl
cbb6 3c        inc     a
cbb7 09        add     hl,bc
cbb8 3004      jr      nc,$cbbe         ; (+$04)
cbba e3        ex      (sp),hl
cbbb e1        pop     hl
cbbc 18f7      jr      $cbb5            ; (-$09)
cbbe e1        pop     hl
cbbf b7        or      a
cbc0 2802      jr      z,$cbc4          ; (+$02)
cbc2 1630      ld      d,$30
cbc4 82        add     a,d
cbc5 1822      jr      $cbe9            ; (+$22)
cbc7 79        ld      a,c
cbc8 c641      add     a,$41
cbca 181d      jr      $cbe9            ; (+$1d)
cbcc f5        push    af
cbcd fe20      cp      $20
cbcf 2017      jr      nz,$cbe8         ; (+$17)
cbd1 e5        push    hl
cbd2 d5        push    de
cbd3 cd69bb    call    $bb69
cbd6 cd78bb    call    $bb78
cbd9 7a        ld      a,d
cbda d604      sub     $04
cbdc 3f        ccf     
cbdd 3001      jr      nc,$cbe0         ; (+$01)
cbdf bc        cp      h
cbe0 d1        pop     de
cbe1 e1        pop     hl
cbe2 3004      jr      nc,$cbe8         ; (+$04)
cbe4 f1        pop     af
cbe5 c34fcb    jp      $cb4f
cbe8 f1        pop     af
cbe9 c35abb    jp      $bb5a

;; messages, terminated with &FF
cbec:
defb &0d,&0a,0x0ff		;; 0
defb "   ",0x0ff		;; 1
defb &fc,"K",0x0ff		;; 2
defb &97,&82," free",&97,0x0ff		;; 3	"K free"
defb &80,"Bad command",&80,0x0ff		;; 4 "Bad command"
defb &9b,"already exists",&80,0x0ff		;; 5 "<filename> already exists"
defb &9b,"not found",&80,0x0ff		;; 6 "<filename> not found"
defb &95,"directory ",&9a,0x0ff		;; 7 "Drive <drive>: directory full"
defb &98,&9a,0x0ff		;; 8 "disc full"
defb &98,"changed, closing ",&fd,&80,0x0ff		;; 9 "disc changed, closing <filename>"
defb &9b,"is ",&9d," only",&80,0x0ff		;; a "<filename> is read only"
defb &fd,0x0ff		;; b "<filename>"
defb &95,"user",&fc,&80,0x0ff		;; c "Drive <drive>: user <user>"
defb "...^C",0x0ff		;; d "..^C"
defb &96,"CP/M",&80,0x0ff		;; e "Failed to load CP/M"
defb &96,"boot sector",&80,0x0ff		;; f "Failed to load boot sector"
defb &95,&9d,&99,0x0ff		;; 10 "Drive <drive>: read fail"
defb &95,&9c,&99,0x0ff		;; 11 "Drive <drive>: write fail"
defb &98,"is ",&9c," protected",&80,0x0ff		;; 12 "Drive <drive>: is write protected"
defb &98,"missing",&80,0x0ff		;; 13 "Drive <drive>: disc missing"
defb &80,"Retry, Ignore or Cancel? ",0x0ff		;; 14 "Retry,Ignore or Cancel? "
defb &80,"Drive ",&fe,": ",0x0ff		;; 15 "Drive <drive>: "
defb &80,"Failed to load ",0x0ff		;; 16 "Failed to load "
defb &80,&80,0x0ff		;; 17
defb &95,"disc ",0x0ff		;; 18 "Drive <drive>: disc"
defb " fail",&80,0x0ff		;; 19 "fail"
defb "full",&80,0x0ff		;; 1a "full"
defb &80,&fd," ",0x0ff		;; 1b "<filename>"
defb "write",0x0ff		;; 1c "write"
defb "read",0x0ff		;; 1d "read"

;;=================================================================

cd00 af        xor     a
cd01 fd7700    ld      (iy+$00),a
cd04 fd7701    ld      (iy+$01),a
cd07 3d        dec     a
cd08 fd7708    ld      (iy+$08),a
cd0b fd772c    ld      (iy+$2c),a
cd0e fd227dbe  ld      ($be7d),iy
cd12 2177bc    ld      hl,$bc77
cd15 116401    ld      de,$0164
cd18 cdfeca    call    $cafe
cd1b 012700    ld      bc,$0027
cd1e edb0      ldir    
cd20 eb        ex      de,hl
cd21 3694      ld      (hl),$94
cd23 23        inc     hl
cd24 36cd      ld      (hl),$cd
cd26 23        inc     hl
cd27 cd12b9    call    $b912
cd2a 77        ld      (hl),a
cd2b 3ec9      ld      a,$c9
cd2d 327fbe    ld      ($be7f),a

;; was fdc detected?
cd30 3a7abe    ld      a,($be7a)
cd33 3c        inc     a
cd34 c0        ret     nz

;; fdc was detected
;; A = 0

;; ===================================================================
;; |DISC 

cd35 cd48cd    call    $cd48
cd38 d0        ret     nc

;; ===================================================================
;; was |DISC.IN in CPC version of AMSDOS
;; not accesible in this version


cd39 2177bc    ld      hl,$bc77
cd3c 0607      ld      b,$07
cd3e cd4dcd    call    $cd4d
cd41 d0        ret     nc

cd42 219bbc    ld      hl,$bc9b
cd45 04        inc     b
cd46 1805      jr      $cd4d            ; (+$05)

;; ===================================================================
;; was |DISC.OUT in CPC version of AMSDOS
;; not accessible in this version

cd48 218cbc    ld      hl,$bc8c
cd4b 0605      ld      b,$05
cd4d b7        or      a
cd4e 203f      jr      nz,$cd8f         ; (+$3f)
cd50 118b01    ld      de,$018b
cd53 cdfeca    call    $cafe
cd56 36df      ld      (hl),$df
cd58 23        inc     hl
cd59 73        ld      (hl),e
cd5a 23        inc     hl
cd5b 72        ld      (hl),d
cd5c 23        inc     hl
cd5d 10f7      djnz    $cd56            ; (-$09)
cd5f 37        scf     
cd60 c9        ret     

;; ==========================================================================
;; |TAPE 

cd61 cd7ccd    call    $cd7c
cd64 d0        ret     nc

;; ==========================================================================
;; was |TAPE.IN in CPC version of AMSDOS
;; not accessible in this version

cd65 216401    ld      hl,$0164
cd68 1177bc    ld      de,$bc77
cd6b 011500    ld      bc,$0015
cd6e cd85cd    call    $cd85
cd71 d0        ret     nc

cd72 218801    ld      hl,$0188
cd75 119bbc    ld      de,$bc9b
cd78 0e03      ld      c,$03
cd7a 1809      jr      $cd85            ; (+$09)

;; ==========================================================================
;; was |TAPE.OUT in CPC version of AMSDOS
;; not accessible in this version

cd7c 217901    ld      hl,$0179
cd7f 118cbc    ld      de,$bc8c
cd82 010f00    ld      bc,$000f

cd85 b7        or      a
cd86 2007      jr      nz,$cd8f         ; (+$07)
cd88 cd05cb    call    $cb05			;; HL = HL + IY
cd8b edb0      ldir    
cd8d 37        scf     
cd8e c9        ret     

cd8f 3e04      ld      a,$04
cd91 c351cb    jp      $cb51

;; ==========================================================================

;; firmware will execute here
;; for all CAS functions
;; 
;; 
cd94 fd2a7dbe  ld      iy,($be7d)
cd98 f3        di      
cd99 08        ex      af,af'
cd9a d9        exx     
cd9b 79        ld      a,c
cd9c d1        pop     de
cd9d c1        pop     bc
cd9e e1        pop     hl
cd9f e3        ex      (sp),hl
cda0 c5        push    bc
cda1 d5        push    de
cda2 4f        ld      c,a
cda3 067f      ld      b,$7f
cda5 113611    ld      de,$1136
cda8 19        add     hl,de
cda9 e5        push    hl
cdaa d9        exx     
cdab 08        ex      af,af'
cdac fb        ei      
cdad c37fbe    jp      $be7f

cdb0 c3a6cf    jp      $cfa6					;; CAS IN OPEN
cdb3 c3add2    jp      $d2ad					;; CAS IN CLOSE
cdb6 c3b3d2    jp      $d2b3					;; CAS IN ABANDON
cdb9 c35bd0    jp      $d05b					;; CAS IN CHAR
cdbc c3ecd0    jp      $d0ec					;; CAS IN DIRECT
cdbf c360d1    jp      $d160					;; CAS RETURN
cdc2 c35cd1    jp      $d15c					;; CAS TEST EOF
cdc5 c32ed0    jp      $d02e					;; CAS OUT OPEN
cdc8 c3cfd2    jp      $d2cf					;; CAS OUT CLOSE
cdcb c3b9d2    jp      $d2b9					;; CAS OUT ABANDON
cdce c386d1    jp      $d186					;; CAS OUT CHAR
cdd1 c3cfd1    jp      $d1cf					;; CAS OUT DIRECT
cdd4 c30ad6    jp      $d60a					;; CAS CATALOG

;;============================================================================
;;
;; startup sequence
;;

;;-------------------------------------------
;; display start-up menu (a null terminated string which contains 
;; control character sequences)

cdd7 2121ce    ld      hl,$ce21			; startup text 

cdda 7e        ld      a,(hl)			; get character code
cddb 23        inc     hl
cddc b7        or      a				; end of string marker (0) ?
cddd 2814      jr      z,$cdf3          ; yes, then continue with start-up sequence

cddf fe1b      cp      $1b				; special control character?
cde1 2805      jr      z,$cde8          ; yes, display horizontal line

cde3 cd5abb    call    $bb5a			; firmware function: txt output
cde6 18f2      jr      $cdda            ; go to next byte

;;---------------------------------------------------------
;; draw 17 horizontal char graphics (char &9a)
cde8 3e9a      ld      a,$9a			; character to display
cdea 0611      ld      b,$11			; number of times to display
cdec cd5abb    call    $bb5a			; firmware function: txt output
cdef 10fb      djnz    $cdec            ; loop
cdf1 18e7      jr      $cdda            ; go back to displaying startup menu

;;---------------------------------------------------------
;; continue startup sequence

;; reset time
;;
cdf3 210000    ld      hl,$0000
cdf6 54        ld      d,h
cdf7 5d        ld      e,l
cdf8 cd10bd    call    $bd10			; firmware function: kl time set

;; query time
cdfb cd0dbd    call    $bd0d			; firmware function: kl time please
										; DE:HL = time

;; check for time-out
cdfe af        xor     a
cdff 11d8dc    ld      de,$dcd8			; ($10000-$dcd8)=$2328 (9000 decimal)
										
										; the count is the number of interrupts
										; these occur approximatly at 1/300th of a second
										; 9000/300 = 30 
										; therefore wait approximatly 30 seconds

ce02 19        add     hl,de
ce03 da5dce    jp      c,$ce5d			; if timeout has occured then start 
										; the built in game

;; check if key pressed
;;
ce06 cd1bbb    call    $bb1b			; firmware function: km read key
ce09 30f0      jr      nc,$cdfb         

;; check for f1 key
ce0b fe81      cp      $81				; f1 key code
ce0d 280c      jr      z,$ce1b          ; f1 key pressed? yes: start basic

;; check for f2 key
ce0f ee82      xor     $82				; f2 key code
ce11 ca5dce    jp      z,$ce5d			; f2 key pressed? yes: start game

;; invalid key pressed (not f1 or f2)

;; make a beep sound
ce14 3e07      ld      a,$07			; BEL control character
ce16 cd5abb    call    $bb5a			; firmware function: txt output

;; restart count and key-check
ce19 18d8      jr      $cdf3            ; reset time

;;----------------------------------------------------------------------------
;; start basic

;; C = rom select
ce1b 210000    ld      hl,$0000			; address to execute
ce1e c316bd    jp      $bd16			; firmware function: mc start program

;;----------------------------------------------------------------------------
;;
;; startup text
;;
;; the control character &1b is defined in basic as "ESC" which has no effect
;; but this is used as a marker to indicate when to draw 17 horizontal 
;; character  graphics (&9a)

ce21:						;; startup text
defb &1f, &07,&0b			;; control character sequence US
							;; move cursor to x (&07), y (&0b) in current window
defb &96					;; char graphic: top-left corner

defb &1b					;; control character sequence ESC (no effect)
							;; but this is redefined

defb &9c					;; char graphic: top-right corner
defb &1f, &07,&0c			;; control character sequence US
							;; move cursor to x (&07), y (&0c) in current window
defb &95
defb "f1 Amstrad BASIC "
defb &95
defb &1f,&07,&0d			;; control character sequence US
							;; move cursor to x (&07), y (&0d) in current window
defb &95
defb "f2 Burnin' Rubber"
defb &95
defb &1f,&07,&0e			;; control character sequence US
							;; move cursor to x (&07), y (&0e) in current window
defb &93

defb &1b
defb &99
defb 13,10,10,0

;;=========================================================================
;; |GAME, |JEUX, |SPIEL, |JUEGO
;; execute built in game
ce5d:
rst     $18							;; firmware function: "low: far call: rst 3" 
defw &ce67							;; address of far call datablock

ce60 f3        di					;; disable interrupts
ce61 01897f    ld      bc,$7f89		;; enable lower rom, set mode 1
ce64 ed49      out     (c),c
ce66 c7        rst     $00			;; execute lower rom

;; far-call datablock
ce67:
defw &c000							;; address to execute
defb &84							;; rom select address (cartridge block 4)


;;=================================================================
ce6a cd6ece    call    $ce6e
ce6d c9        ret     

;;=================================================================

ce6e e5        push    hl
ce6f 210600    ld      hl,$0006
ce72 39        add     hl,sp
ce73 fd7506    ld      (iy+$06),l
ce76 fd7407    ld      (iy+$07),h
ce79 e1        pop     hl
ce7a c9        ret     

ce7b cd6ece    call    $ce6e
ce7e f5        push    af
ce7f fd7e08    ld      a,(iy+$08)
ce82 1807      jr      $ce8b            ; (+$07)
ce84 cd6ece    call    $ce6e
ce87 f5        push    af
ce88 fd7e2c    ld      a,(iy+$2c)
ce8b feff      cp      $ff
ce8d 2812      jr      z,$cea1          ; (+$12)
ce8f cd0dcf    call    $cf0d
ce92 f1        pop     af
ce93 c9        ret     

ce94 fd7e08    ld      a,(iy+$08)
ce97 1803      jr      $ce9c            ; (+$03)
ce99 fd7e2c    ld      a,(iy+$2c)
ce9c cd6ece    call    $ce6e
ce9f 3c        inc     a
cea0 c8        ret     z

cea1 3e0e      ld      a,$0e
cea3 b7        or      a
cea4 180a      jr      $ceb0            ; (+$0a)
cea6 3e04      ld      a,$04
cea8 cdc1dc    call    $dcc1
ceab c60c      add     a,$0c
cead f680      or      $80
ceaf bf        cp      a
ceb0 fd6e06    ld      l,(iy+$06)
ceb3 fd6607    ld      h,(iy+$07)
ceb6 f9        ld      sp,hl
ceb7 c9        ret     

ceb8 3d        dec     a
ceb9 3d        dec     a
ceba c8        ret     z

cebb c3a6ce    jp      $cea6
cebe cdc6ce    call    $cec6
cec1 46        ld      b,(hl)
cec2 23        inc     hl
cec3 c3f0dc    jp      $dcf0
cec6 dd6e00    ld      l,(ix+$00)
cec9 dd6601    ld      h,(ix+$01)
cecc dd23      inc     ix
cece dd23      inc     ix
ced0 c9        ret     

ced1 af        xor     a
ced2 1802      jr      $ced6            ; (+$02)
ced4 3e01      ld      a,$01
ced6 cd6ace    call    $ce6a
ced9 1813      jr      $ceee            ; (+$13)
cedb cd6ace    call    $ce6a
cede cdb9ce    call    $ceb9
cee1 cdbece    call    $cebe
cee4 05        dec     b
cee5 c2a6ce    jp      nz,$cea6
cee8 7e        ld      a,(hl)
cee9 cd0ccb    call    $cb0c			; convert to upper case
ceec d641      sub     $41
ceee cd0dcf    call    $cf0d
cef1 fd7700    ld      (iy+$00),a
cef4 c9        ret     

cef5 cd6ace    call    $ce6a
cef8 cdb9ce    call    $ceb9
cefb cdc6ce    call    $cec6
cefe 111000    ld      de,$0010
cf01 cdeadc    call    $dcea
cf04 d2a6ce    jp      nc,$cea6
cf07 fd7501    ld      (iy+$01),l
cf0a c9        ret     

cf0b 0a        ld      a,(bc)
cf0c 03        inc     bc
cf0d e5        push    hl
cf0e d5        push    de
cf0f c5        push    bc
cf10 f5        push    af
cf11 4f        ld      c,a
cf12 1eff      ld      e,$ff
cf14 fd7e08    ld      a,(iy+$08)
cf17 b9        cp      c
cf18 2808      jr      z,$cf22          ; (+$08)
cf1a fd7e2c    ld      a,(iy+$2c)
cf1d b9        cp      c
cf1e 2802      jr      z,$cf22          ; (+$02)
cf20 1e00      ld      e,$00
cf22 d5        push    de
cf23 c5        push    bc
cf24 cdf0c4    call    $c4f0
cf27 c1        pop     bc
cf28 d1        pop     de
cf29 7c        ld      a,h
cf2a b5        or      l
cf2b caa6ce    jp      z,$cea6
cf2e fd7503    ld      (iy+$03),l
cf31 fd7404    ld      (iy+$04),h
cf34 fd7305    ld      (iy+$05),e
cf37 fd7102    ld      (iy+$02),c
cf3a f1        pop     af
cf3b c1        pop     bc
cf3c d1        pop     de
cf3d e1        pop     hl
cf3e c9        ret     

cf3f 215000    ld      hl,$0050
cf42 cd51cf    call    $cf51
cf45 e5        push    hl
cf46 114200    ld      de,$0042
cf49 19        add     hl,de
cf4a 3680      ld      (hl),$80
cf4c e1        pop     hl
cf4d c9        ret     

cf4e 219a00    ld      hl,$009a
cf51 c5        push    bc
cf52 d5        push    de
cf53 cd05cb    call    $cb05				;; HL = HL + IY
cf56 3600      ld      (hl),$00
cf58 23        inc     hl
cf59 73        ld      (hl),e
cf5a 23        inc     hl
cf5b 72        ld      (hl),d
cf5c 23        inc     hl
cf5d 73        ld      (hl),e
cf5e 23        inc     hl
cf5f 72        ld      (hl),d
cf60 23        inc     hl
cf61 e5        push    hl
cf62 c5        push    bc
cf63 014500    ld      bc,$0045
cf66 eb        ex      de,hl
cf67 cd15cb    call    $cb15				;; clear block
cf6a c1        pop     bc
cf6b 60        ld      h,b
cf6c 69        ld      l,c
cf6d d1        pop     de
cf6e d5        push    de
cf6f 010c00    ld      bc,$000c
cf72 edb0      ldir    
cf74 e1        pop     hl
cf75 d1        pop     de
cf76 e5        push    hl
cf77 011200    ld      bc,$0012
cf7a 09        add     hl,bc
cf7b 3616      ld      (hl),$16
cf7d 23        inc     hl
cf7e 23        inc     hl
cf7f 23        inc     hl
cf80 73        ld      (hl),e
cf81 23        inc     hl
cf82 72        ld      (hl),d
cf83 23        inc     hl
cf84 36ff      ld      (hl),$ff
cf86 e1        pop     hl
cf87 c1        pop     bc
cf88 c9        ret     

cf89 e5        push    hl
cf8a 210000    ld      hl,$0000
cf8d 54        ld      d,h
cf8e 0643      ld      b,$43
cf90 e3        ex      (sp),hl
cf91 7e        ld      a,(hl)
cf92 23        inc     hl
cf93 e3        ex      (sp),hl
cf94 5f        ld      e,a
cf95 19        add     hl,de
cf96 10f8      djnz    $cf90            ; (-$08)
cf98 eb        ex      de,hl
cf99 e1        pop     hl
cf9a c9        ret     

cf9b e5        push    hl
cf9c cd89cf    call    $cf89
cf9f 73        ld      (hl),e
cfa0 23        inc     hl
cfa1 72        ld      (hl),d
cfa2 e1        pop     hl
cfa3 c3f0d4    jp      $d4f0
cfa6 cd94ce    call    $ce94
cfa9 d5        push    de
cfaa cd66db    call    $db66
cfad cd0bcf    call    $cf0b
cfb0 210900    ld      hl,$0009
cfb3 09        add     hl,bc
cfb4 7e        ld      a,(hl)
cfb5 3c        inc     a
cfb6 2808      jr      z,$cfc0          ; (+$08)
cfb8 cd49d7    call    $d749
cfbb d203d6    jp      nc,$d603
cfbe 181e      jr      $cfde            ; (+$1e)
cfc0 cd9fd3    call    $d39f
cfc3 cd49d7    call    $d749
cfc6 3816      jr      c,$cfde          ; (+$16)
cfc8 cdaad3    call    $d3aa
cfcb cd49d7    call    $d749
cfce 380e      jr      c,$cfde          ; (+$0e)
cfd0 cdaed3    call    $d3ae
cfd3 cd49d7    call    $d749
cfd6 f5        push    af
cfd7 d49fd3    call    nc,$d39f
cfda f1        pop     af
cfdb d203d6    jp      nc,$d603
cfde d1        pop     de
cfdf cd3fcf    call    $cf3f
cfe2 e5        push    hl
cfe3 110800    ld      de,$0008
cfe6 cdfeca    call    $cafe
cfe9 0b        dec     bc
cfea 0a        ld      a,(bc)
cfeb 12        ld      (de),a
cfec cd93d8    call    $d893
cfef 21e400    ld      hl,$00e4
cff2 cd05cb    call    $cb05			;; HL = HL + IY
cff5 cd89d4    call    $d489
cff8 301f      jr      nc,$d019         ; (+$1f)
cffa e5        push    hl
cffb d5        push    de
cffc cd89cf    call    $cf89
cfff cdf0dc    call    $dcf0
d002 cdeadc    call    $dcea
d005 d1        pop     de
d006 e1        pop     hl
d007 200d      jr      nz,$d016         ; (+$0d)
d009 115500    ld      de,$0055
d00c cdfeca    call    $cafe
d00f 014500    ld      bc,$0045
d012 edb0      ldir    
d014 1803      jr      $d019            ; (+$03)
d016 cd93d8    call    $d893
d019 e1        pop     hl
d01a e5        push    hl
d01b 111500    ld      de,$0015
d01e 19        add     hl,de
d01f 5e        ld      e,(hl)
d020 23        inc     hl
d021 56        ld      d,(hl)
d022 23        inc     hl
d023 23        inc     hl
d024 4e        ld      c,(hl)
d025 23        inc     hl
d026 46        ld      b,(hl)
d027 e1        pop     hl
d028 37        scf     
d029 9f        sbc     a,a
d02a fd7e67    ld      a,(iy+$67)
d02d c9        ret     

d02e cd99ce    call    $ce99
d031 d5        push    de
d032 cd61db    call    $db61
d035 cd0bcf    call    $cf0b
d038 d1        pop     de
d039 cd4ecf    call    $cf4e
d03c e5        push    hl
d03d cda2d3    call    $d3a2
d040 cd6ed7    call    $d76e
d043 60        ld      h,b
d044 69        ld      l,c
d045 2b        dec     hl
d046 112c00    ld      de,$002c
d049 cdfeca    call    $cafe
d04c 010d00    ld      bc,$000d
d04f edb0      ldir    
d051 011700    ld      bc,$0017
d054 cd15cb    call    $cb15				;; clear block
d057 e1        pop     hl
d058 37        scf     
d059 9f        sbc     a,a
d05a c9        ret     

d05b e5        push    hl
d05c d5        push    de
d05d c5        push    bc
d05e cd6bd0    call    $d06b
d061 c1        pop     bc
d062 d1        pop     de
d063 e1        pop     hl
d064 d0        ret     nc

d065 fe1a      cp      $1a
d067 37        scf     
d068 c0        ret     nz

d069 b7        or      a
d06a c9        ret     

d06b cd7bce    call    $ce7b
d06e fde5      push    iy
d070 d1        pop     de
d071 215000    ld      hl,$0050
d074 19        add     hl,de
d075 7e        ld      a,(hl)
d076 fe02      cp      $02
d078 caa1ce    jp      z,$cea1
d07b 3601      ld      (hl),$01
d07d 219500    ld      hl,$0095
d080 19        add     hl,de
d081 7e        ld      a,(hl)
d082 23        inc     hl
d083 b6        or      (hl)
d084 23        inc     hl
d085 b6        or      (hl)
d086 2836      jr      z,$d0be          ; (+$36)
d088 216800    ld      hl,$0068
d08b 19        add     hl,de
d08c 7e        ld      a,(hl)
d08d 23        inc     hl
d08e b6        or      (hl)
d08f 2b        dec     hl
d090 ccc2d0    call    z,$d0c2
d093 7e        ld      a,(hl)
d094 23        inc     hl
d095 b6        or      (hl)
d096 2826      jr      z,$d0be          ; (+$26)
d098 46        ld      b,(hl)
d099 2b        dec     hl
d09a 4e        ld      c,(hl)
d09b 0b        dec     bc
d09c 71        ld      (hl),c
d09d 23        inc     hl
d09e 70        ld      (hl),b
d09f 219500    ld      hl,$0095
d0a2 19        add     hl,de
d0a3 0603      ld      b,$03
d0a5 7e        ld      a,(hl)
d0a6 d601      sub     $01
d0a8 77        ld      (hl),a
d0a9 3003      jr      nc,$d0ae         ; (+$03)
d0ab 23        inc     hl
d0ac 10f7      djnz    $d0a5            ; (-$09)
d0ae 215300    ld      hl,$0053
d0b1 19        add     hl,de
d0b2 5e        ld      e,(hl)
d0b3 23        inc     hl
d0b4 56        ld      d,(hl)
d0b5 eb        ex      de,hl
d0b6 e7        rst     $20
d0b7 eb        ex      de,hl
d0b8 13        inc     de
d0b9 72        ld      (hl),d
d0ba 2b        dec     hl
d0bb 73        ld      (hl),e
d0bc 37        scf     
d0bd c9        ret     

d0be 3e0f      ld      a,$0f
d0c0 b7        or      a
d0c1 c9        ret     

d0c2 e5        push    hl
d0c3 d5        push    de
d0c4 e5        push    hl
d0c5 215100    ld      hl,$0051
d0c8 19        add     hl,de
d0c9 cdf0dc    call    $dcf0
d0cc e5        push    hl
d0cd 011000    ld      bc,$0010
d0d0 cd40d1    call    $d140
d0d3 3e10      ld      a,$10
d0d5 91        sub     c
d0d6 47        ld      b,a
d0d7 0e00      ld      c,$00
d0d9 cb38      srl     b
d0db cb19      rr      c
d0dd d1        pop     de
d0de e1        pop     hl
d0df 71        ld      (hl),c
d0e0 23        inc     hl
d0e1 70        ld      (hl),b
d0e2 01eaff    ld      bc,$ffea
d0e5 09        add     hl,bc
d0e6 73        ld      (hl),e
d0e7 23        inc     hl
d0e8 72        ld      (hl),d
d0e9 d1        pop     de
d0ea e1        pop     hl
d0eb c9        ret     

d0ec cd7bce    call    $ce7b
d0ef e5        push    hl
d0f0 215000    ld      hl,$0050
d0f3 cd05cb    call    $cb05			;; HL = HL + IY
d0f6 7e        ld      a,(hl)
d0f7 fe01      cp      $01
d0f9 caa1ce    jp      z,$cea1
d0fc 3602      ld      (hl),$02
d0fe 114500    ld      de,$0045
d101 19        add     hl,de
d102 5e        ld      e,(hl)
d103 23        inc     hl
d104 56        ld      d,(hl)
d105 e1        pop     hl
d106 d5        push    de
d107 e5        push    hl
d108 eb        ex      de,hl
d109 3e07      ld      a,$07
d10b cde2dc    call    $dce2
d10e 44        ld      b,h
d10f 4d        ld      c,l
d110 e1        pop     hl
d111 cd40d1    call    $d140
d114 d1        pop     de
d115 301e      jr      nc,$d135         ; (+$1e)
d117 7b        ld      a,e
d118 e67f      and     $7f
d11a 2819      jr      z,$d135          ; (+$19)
d11c f5        push    af
d11d e5        push    hl
d11e 21e400    ld      hl,$00e4
d121 cd05cb    call    $cb05			;; HL = HL + IY
d124 e5        push    hl
d125 010100    ld      bc,$0001
d128 cd40d1    call    $d140
d12b e1        pop     hl
d12c d1        pop     de
d12d c1        pop     bc
d12e 3005      jr      nc,$d135         ; (+$05)
d130 48        ld      c,b
d131 0600      ld      b,$00
d133 edb0      ldir    
d135 216f00    ld      hl,$006f
d138 cd05cb    call    $cb05			;; HL = HL + IY
d13b 37        scf     
d13c 9f        sbc     a,a
d13d c3f0dc    jp      $dcf0
d140 1814      jr      $d156            ; (+$14)
d142 cd89d4    call    $d489
d145 d0        ret     nc

d146 116700    ld      de,$0067
d149 cdfeca    call    $cafe
d14c 1a        ld      a,(de)
d14d 1f        rra     
d14e dc49d3    call    c,$d349
d151 118000    ld      de,$0080
d154 19        add     hl,de
d155 0b        dec     bc
d156 78        ld      a,b
d157 b1        or      c
d158 20e8      jr      nz,$d142         ; (-$18)
d15a 37        scf     
d15b c9        ret     

d15c cd5bd0    call    $d05b
d15f d0        ret     nc

d160 e5        push    hl
d161 d5        push    de
d162 f5        push    af
d163 215300    ld      hl,$0053
d166 cd05cb    call    $cb05			;; HL = HL + IY
d169 5e        ld      e,(hl)
d16a 23        inc     hl
d16b 56        ld      d,(hl)
d16c 1b        dec     de
d16d 72        ld      (hl),d
d16e 2b        dec     hl
d16f 73        ld      (hl),e
d170 54        ld      d,h
d171 5d        ld      e,l
d172 214200    ld      hl,$0042
d175 19        add     hl,de
d176 cda2d8    call    $d8a2
d179 211500    ld      hl,$0015
d17c 19        add     hl,de
d17d 34        inc     (hl)
d17e 2002      jr      nz,$d182         ; (+$02)
d180 23        inc     hl
d181 34        inc     (hl)
d182 f1        pop     af
d183 d1        pop     de
d184 e1        pop     hl
d185 c9        ret     

d186 cd84ce    call    $ce84
d189 e5        push    hl
d18a d5        push    de
d18b c5        push    bc
d18c f5        push    af
d18d fde5      push    iy
d18f d1        pop     de
d190 219a00    ld      hl,$009a
d193 19        add     hl,de
d194 7e        ld      a,(hl)
d195 fe02      cp      $02
d197 caa1ce    jp      z,$cea1
d19a 3601      ld      (hl),$01
d19c 21b200    ld      hl,$00b2
d19f 19        add     hl,de
d1a0 e5        push    hl
d1a1 cdf0dc    call    $dcf0
d1a4 0100f8    ld      bc,$f800
d1a7 09        add     hl,bc
d1a8 d5        push    de
d1a9 dc0fd2    call    c,$d20f
d1ac d1        pop     de
d1ad e1        pop     hl
d1ae 34        inc     (hl)
d1af 23        inc     hl
d1b0 2001      jr      nz,$d1b3         ; (+$01)
d1b2 34        inc     (hl)
d1b3 21df00    ld      hl,$00df
d1b6 19        add     hl,de
d1b7 cda2d8    call    $d8a2
d1ba 219d00    ld      hl,$009d
d1bd 19        add     hl,de
d1be f1        pop     af
d1bf 4e        ld      c,(hl)
d1c0 23        inc     hl
d1c1 46        ld      b,(hl)
d1c2 2b        dec     hl
d1c3 02        ld      (bc),a
d1c4 34        inc     (hl)
d1c5 2002      jr      nz,$d1c9         ; (+$02)
d1c7 23        inc     hl
d1c8 34        inc     (hl)
d1c9 c1        pop     bc
d1ca d1        pop     de
d1cb e1        pop     hl
d1cc 37        scf     
d1cd 9f        sbc     a,a
d1ce c9        ret     

d1cf cd84ce    call    $ce84
d1d2 f5        push    af
d1d3 e5        push    hl
d1d4 d5        push    de
d1d5 219a00    ld      hl,$009a
d1d8 cd05cb    call    $cb05				;; HL = HL + IY
d1db 7e        ld      a,(hl)
d1dc fe01      cp      $01
d1de caa1ce    jp      z,$cea1
d1e1 3602      ld      (hl),$02
d1e3 112000    ld      de,$0020
d1e6 19        add     hl,de
d1e7 70        ld      (hl),b
d1e8 2b        dec     hl
d1e9 71        ld      (hl),c
d1ea c1        pop     bc
d1eb 2b        dec     hl
d1ec 70        ld      (hl),b
d1ed 2b        dec     hl
d1ee 71        ld      (hl),c
d1ef 112900    ld      de,$0029
d1f2 19        add     hl,de
d1f3 70        ld      (hl),b
d1f4 2b        dec     hl
d1f5 71        ld      (hl),c
d1f6 11d3ff    ld      de,$ffd3
d1f9 19        add     hl,de
d1fa 71        ld      (hl),c
d1fb 23        inc     hl
d1fc 70        ld      (hl),b
d1fd c1        pop     bc
d1fe 23        inc     hl
d1ff 71        ld      (hl),c
d200 23        inc     hl
d201 70        ld      (hl),b
d202 11e6ff    ld      de,$ffe6
d205 19        add     hl,de
d206 71        ld      (hl),c
d207 23        inc     hl
d208 70        ld      (hl),b
d209 f1        pop     af
d20a 111500    ld      de,$0015
d20d 19        add     hl,de
d20e 77        ld      (hl),a
d20f fde5      push    iy
d211 d1        pop     de
d212 21b600    ld      hl,$00b6
d215 19        add     hl,de
d216 7e        ld      a,(hl)
d217 b7        or      a
d218 2818      jr      z,$d232          ; (+$18)
d21a 21b100    ld      hl,$00b1
d21d 19        add     hl,de
d21e 7e        ld      a,(hl)
d21f e60f      and     $0f
d221 fe06      cp      $06
d223 280d      jr      z,$d232          ; (+$0d)
d225 212c00    ld      hl,$002c
d228 19        add     hl,de
d229 d5        push    de
d22a eb        ex      de,hl
d22b cd9ed8    call    $d89e
d22e cd74d8    call    $d874
d231 d1        pop     de
d232 21b200    ld      hl,$00b2
d235 19        add     hl,de
d236 e5        push    hl
d237 5e        ld      e,(hl)
d238 23        inc     hl
d239 56        ld      d,(hl)
d23a 01e8ff    ld      bc,$ffe8
d23d 09        add     hl,bc
d23e cdf0dc    call    $dcf0
d241 e5        push    hl
d242 cd5bd2    call    $d25b
d245 c1        pop     bc
d246 e1        pop     hl
d247 3600      ld      (hl),$00
d249 23        inc     hl
d24a 3600      ld      (hl),$00
d24c 23        inc     hl
d24d 23        inc     hl
d24e 23        inc     hl
d24f 3600      ld      (hl),$00
d251 11e7ff    ld      de,$ffe7
d254 19        add     hl,de
d255 71        ld      (hl),c
d256 23        inc     hl
d257 70        ld      (hl),b
d258 37        scf     
d259 9f        sbc     a,a
d25a c9        ret     

d25b d5        push    de
d25c 3e07      ld      a,$07
d25e eb        ex      de,hl
d25f cde2dc    call    $dce2
d262 eb        ex      de,hl
d263 42        ld      b,d
d264 4b        ld      c,e
d265 cd7fd2    call    $d27f
d268 c1        pop     bc
d269 79        ld      a,c
d26a e67f      and     $7f
d26c c8        ret     z

d26d 4f        ld      c,a
d26e 0600      ld      b,$00
d270 11e400    ld      de,$00e4
d273 cdfeca    call    $cafe
d276 d5        push    de
d277 cd1bb9    call    $b91b
d27a 3e1a      ld      a,$1a
d27c 12        ld      (de),a
d27d e1        pop     hl
d27e 03        inc     bc
d27f 1827      jr      $d2a8            ; (+$27)
d281 e5        push    hl
d282 11b100    ld      de,$00b1
d285 cdfeca    call    $cafe
d288 1a        ld      a,(de)
d289 1f        rra     
d28a 3013      jr      nc,$d29f         ; (+$13)
d28c c5        push    bc
d28d 11e400    ld      de,$00e4
d290 cdfeca    call    $cafe
d293 d5        push    de
d294 018000    ld      bc,$0080
d297 cd1bb9    call    $b91b
d29a e1        pop     hl
d29b c1        pop     bc
d29c cd49d3    call    $d349
d29f cda6d4    call    $d4a6
d2a2 e1        pop     hl
d2a3 118000    ld      de,$0080
d2a6 19        add     hl,de
d2a7 0b        dec     bc
d2a8 78        ld      a,b
d2a9 b1        or      c
d2aa 20d5      jr      nz,$d281         ; (-$2b)
d2ac c9        ret     

d2ad cd7bce    call    $ce7b
d2b0 cd47ca    call    $ca47
d2b3 fd3608ff  ld      (iy+$08),$ff
d2b7 186e      jr      $d327            ; (+$6e)
d2b9 cd84ce    call    $ce84
d2bc 112d00    ld      de,$002d
d2bf cdfeca    call    $cafe
d2c2 af        xor     a
d2c3 cd33d9    call    $d933
d2c6 1b        dec     de
d2c7 3eff      ld      a,$ff
d2c9 12        ld      (de),a
d2ca cd1fc5    call    $c51f
d2cd 1858      jr      $d327            ; (+$58)
d2cf 21df00    ld      hl,$00df
d2d2 cd05cb    call    $cb05			;; HL = HL + IY
d2d5 7e        ld      a,(hl)
d2d6 23        inc     hl
d2d7 b6        or      (hl)
d2d8 23        inc     hl
d2d9 b6        or      (hl)
d2da 28dd      jr      z,$d2b9          ; (-$23)
d2dc cd84ce    call    $ce84
d2df cd0fd2    call    $d20f
d2e2 112c00    ld      de,$002c
d2e5 cdfeca    call    $cafe
d2e8 d5        push    de
d2e9 cd83d8    call    $d883
d2ec 019f00    ld      bc,$009f
d2ef cdf6ca    call    $caf6
d2f2 211200    ld      hl,$0012
d2f5 09        add     hl,bc
d2f6 5e        ld      e,(hl)
d2f7 210900    ld      hl,$0009
d2fa 09        add     hl,bc
d2fb 7e        ld      a,(hl)
d2fc 3c        inc     a
d2fd 2016      jr      nz,$d315         ; (+$16)
d2ff 7b        ld      a,e
d300 e60e      and     $0e
d302 2005      jr      nz,$d309         ; (+$05)
d304 cdaad3    call    $d3aa
d307 180c      jr      $d315            ; (+$0c)
d309 fe02      cp      $02
d30b 2005      jr      nz,$d312         ; (+$05)
d30d cdaed3    call    $d3ae
d310 1803      jr      $d315            ; (+$03)
d312 cd9fd3    call    $d39f
d315 60        ld      h,b
d316 69        ld      l,c
d317 7b        ld      a,e
d318 e60f      and     $0f
d31a fe06      cp      $06
d31c c49bcf    call    nz,$cf9b
d31f c1        pop     bc
d320 3eff      ld      a,$ff
d322 02        ld      (bc),a
d323 03        inc     bc
d324 cdd1d3    call    $d3d1
d327 37        scf     
d328 9f        sbc     a,a
d329 c9        ret     

d32a fd6602    ld      h,(iy+$02)
d32d fd360500  ld      (iy+$05),$00
d331 110800    ld      de,$0008
d334 cd3ad3    call    $d33a
d337 112c00    ld      de,$002c
d33a cdfeca    call    $cafe
d33d 1a        ld      a,(de)
d33e bc        cp      h
d33f c0        ret     nz

d340 3eff      ld      a,$ff
d342 12        ld      (de),a
d343 13        inc     de
d344 3e09      ld      a,$09
d346 c3c1dc    jp      $dcc1
d349 e5        push    hl
d34a c5        push    bc
d34b e5        push    hl
d34c 110101    ld      de,$0101
d34f 0681      ld      b,$81
d351 180e      jr      $d361            ; (+$0e)
d353 e3        ex      (sp),hl
d354 e7        rst     $20
d355 e3        ex      (sp),hl
d356 ae        xor     (hl)
d357 ddae00    xor     (ix+$00)
d35a e3        ex      (sp),hl
d35b 77        ld      (hl),a
d35c 23        inc     hl
d35d e3        ex      (sp),hl
d35e dd23      inc     ix
d360 23        inc     hl
d361 15        dec     d
d362 2006      jr      nz,$d36a         ; (+$06)
d364 160b      ld      d,$0b
d366 dd2178d3  ld      ix,$d378
d36a 1d        dec     e
d36b 2005      jr      nz,$d372         ; (+$05)
d36d 1e0d      ld      e,$0d
d36f 2183d3    ld      hl,$d383
d372 10df      djnz    $d353            ; (-$21)
d374 e1        pop     hl
d375 c1        pop     bc
d376 e1        pop     hl
d377 c9        ret     

d378 49        ld      c,c
d379 b1        or      c
d37a 36f0      ld      (hl),$f0
d37c 2e1e      ld      l,$1e
d37e 062a      ld      b,$2a
d380 2819      jr      z,$d39b          ; (+$19)
d382 eae29d    jp      pe,$9de2
d385 db1a      in      a,($1a)
d387 42        ld      b,d
d388 29        add     hl,hl
d389 39        add     hl,sp
d38a c6b3      add     a,$b3
d38c c690      add     a,$90
d38e 45        ld      b,l
d38f 8a        adc     a,d
d390 2020      jr      nz,$d3b2         ; (+$20)
d392 2024      jr      nz,$d3b8         ; (+$24)
d394 24        inc     h
d395 24        inc     h
d396 42        ld      b,d
d397 41        ld      b,c
d398 4b        ld      c,e
d399 42        ld      b,d
d39a 41        ld      b,c
d39b 53        ld      d,e
d39c 42        ld      b,d
d39d 49        ld      c,c
d39e 4e        ld      c,(hl)
d39f af        xor     a
d3a0 180e      jr      $d3b0            ; (+$0e)
d3a2 3e03      ld      a,$03
d3a4 180a      jr      $d3b0            ; (+$0a)
d3a6 3e06      ld      a,$06
d3a8 1806      jr      $d3b0            ; (+$06)
d3aa 3e09      ld      a,$09
d3ac 1802      jr      $d3b0            ; (+$02)
d3ae 3e0c      ld      a,$0c
d3b0 d5        push    de
d3b1 c690      add     a,$90
d3b3 5f        ld      e,a
d3b4 ced3      adc     a,$d3
d3b6 93        sub     e
d3b7 57        ld      d,a
d3b8 1807      jr      $d3c1            ; (+$07)
d3ba d5        push    de
d3bb 11a800    ld      de,$00a8
d3be cdfeca    call    $cafe
d3c1 e5        push    hl
d3c2 c5        push    bc
d3c3 210900    ld      hl,$0009
d3c6 09        add     hl,bc
d3c7 010300    ld      bc,$0003
d3ca eb        ex      de,hl
d3cb edb0      ldir    
d3cd c1        pop     bc
d3ce e1        pop     hl
d3cf d1        pop     de
d3d0 c9        ret     

d3d1 210c00    ld      hl,$000c
d3d4 09        add     hl,bc
d3d5 36ff      ld      (hl),$ff
d3d7 23        inc     hl
d3d8 23        inc     hl
d3d9 36ff      ld      (hl),$ff
d3db cd7bd7    call    $d77b
d3de e5        push    hl
d3df 210000    ld      hl,$0000
d3e2 e3        ex      (sp),hl
d3e3 cd9ad7    call    $d79a
d3e6 e3        ex      (sp),hl
d3e7 3028      jr      nc,$d411         ; (+$28)
d3e9 cda6d3    call    $d3a6
d3ec cdcfd8    call    $d8cf
d3ef 3008      jr      nc,$d3f9         ; (+$08)
d3f1 2601      ld      h,$01
d3f3 cdd0da    call    $dad0
d3f6 3801      jr      c,$d3f9          ; (+$01)
d3f8 24        inc     h
d3f9 cdbad3    call    $d3ba
d3fc cdcfd8    call    $d8cf
d3ff 3008      jr      nc,$d409         ; (+$08)
d401 2e01      ld      l,$01
d403 cdd0da    call    $dad0
d406 3801      jr      c,$d409          ; (+$01)
d408 2c        inc     l
d409 7c        ld      a,h
d40a b7        or      a
d40b 28d5      jr      z,$d3e2          ; (-$2b)
d40d 7d        ld      a,l
d40e b7        or      a
d40f 28d1      jr      z,$d3e2          ; (-$2f)
d411 f1        pop     af
d412 7d        ld      a,l
d413 b7        or      a
d414 2843      jr      z,$d459          ; (+$43)
d416 3d        dec     a
d417 2866      jr      z,$d47f          ; (+$66)
d419 7c        ld      a,h
d41a b7        or      a
d41b 283c      jr      z,$d459          ; (+$3c)
d41d 3d        dec     a
d41e 2845      jr      z,$d465          ; (+$45)
d420 cd7bd7    call    $d77b
d423 cd9ad7    call    $d79a
d426 d0        ret     nc

d427 cd2cd4    call    $d42c
d42a 18f7      jr      $d423            ; (-$09)
d42c cda6d3    call    $d3a6
d42f cdcfd8    call    $d8cf
d432 daa1d5    jp      c,$d5a1
d435 cd48d4    call    $d448
d438 d8        ret     c

d439 cdbad3    call    $d3ba
d43c cdcfd8    call    $d8cf
d43f d0        ret     nc

d440 c5        push    bc
d441 42        ld      b,d
d442 4b        ld      c,e
d443 cda6d3    call    $d3a6
d446 180d      jr      $d455            ; (+$0d)
d448 cda2d3    call    $d3a2
d44b cdcfd8    call    $d8cf
d44e d0        ret     nc

d44f c5        push    bc
d450 42        ld      b,d
d451 4b        ld      c,e
d452 cdbad3    call    $d3ba
d455 c1        pop     bc
d456 c371da    jp      $da71
d459 cd7bd7    call    $d77b
d45c cd9ad7    call    $d79a
d45f d0        ret     nc

d460 cd35d4    call    $d435
d463 18f7      jr      $d45c            ; (-$09)
d465 cd7bd7    call    $d77b
d468 cd9ad7    call    $d79a
d46b d0        ret     nc

d46c cd71d4    call    $d471
d46f 18f7      jr      $d468            ; (-$09)
d471 cd48d4    call    $d448
d474 d8        ret     c

d475 cdbad3    call    $d3ba
d478 cdcfd8    call    $d8cf
d47b daa1d5    jp      c,$d5a1
d47e c9        ret     

d47f cdbad3    call    $d3ba
d482 50        ld      d,b
d483 59        ld      e,c
d484 3e0a      ld      a,$0a
d486 c3a8ce    jp      $cea8
d489 e5        push    hl
d48a d5        push    de
d48b c5        push    bc
d48c e5        push    hl
d48d 110800    ld      de,$0008
d490 cdfeca    call    $cafe
d493 cd07d5    call    $d507
d496 3008      jr      nc,$d4a0         ; (+$08)
d498 eb        ex      de,hl
d499 e3        ex      (sp),hl
d49a cddfda    call    $dadf
d49d d1        pop     de
d49e 1848      jr      $d4e8            ; (+$48)
d4a0 e1        pop     hl
d4a1 c1        pop     bc
d4a2 d1        pop     de
d4a3 e1        pop     hl
d4a4 b7        or      a
d4a5 c9        ret     

d4a6 e5        push    hl
d4a7 d5        push    de
d4a8 c5        push    bc
d4a9 e5        push    hl
d4aa 112c00    ld      de,$002c
d4ad cdfeca    call    $cafe
d4b0 cdc0d7    call    $d7c0
d4b3 380b      jr      c,$d4c0          ; (+$0b)
d4b5 3e08      ld      a,$08
d4b7 c2a8ce    jp      nz,$cea8
d4ba cd83d8    call    $d883
d4bd cdf2d7    call    $d7f2
d4c0 cd26d8    call    $d826
d4c3 0e00      ld      c,$00
d4c5 3818      jr      c,$d4df          ; (+$18)
d4c7 d5        push    de
d4c8 eb        ex      de,hl
d4c9 cd8ad9    call    $d98a
d4cc eb        ex      de,hl
d4cd 3e08      ld      a,$08
d4cf d2a8ce    jp      nc,$cea8
d4d2 73        ld      (hl),e
d4d3 78        ld      a,b
d4d4 b7        or      a
d4d5 2802      jr      z,$d4d9          ; (+$02)
d4d7 23        inc     hl
d4d8 72        ld      (hl),d
d4d9 d1        pop     de
d4da cd26d8    call    $d826
d4dd 0e02      ld      c,$02
d4df eb        ex      de,hl
d4e0 e3        ex      (sp),hl
d4e1 cdeada    call    $daea
d4e4 d1        pop     de
d4e5 cd74d8    call    $d874
d4e8 cd9ed8    call    $d89e
d4eb c1        pop     bc
d4ec d1        pop     de
d4ed e1        pop     hl
d4ee 37        scf     
d4ef c9        ret     

d4f0 e5        push    hl
d4f1 112c00    ld      de,$002c
d4f4 cdfeca    call    $cafe
d4f7 cd93d8    call    $d893
d4fa cd07d5    call    $d507
d4fd eb        ex      de,hl
d4fe e1        pop     hl
d4ff 0e00      ld      c,$00
d501 daeada    jp      c,$daea
d504 c3a6ce    jp      $cea6
d507 cdc0d7    call    $d7c0
d50a 3812      jr      c,$d51e          ; (+$12)
d50c c0        ret     nz

d50d cdf2d7    call    $d7f2
d510 d5        push    de
d511 42        ld      b,d
d512 4b        ld      c,e
d513 03        inc     bc
d514 c5        push    bc
d515 cdaad8    call    $d8aa
d518 eb        ex      de,hl
d519 d1        pop     de
d51a dcd6dc    call    c,$dcd6
d51d d1        pop     de
d51e dc04d8    call    c,$d804
d521 da26d8    jp      c,$d826
d524 c9        ret     

d525 cd6ace    call    $ce6a
d528 0600      ld      b,$00
d52a b7        or      a
d52b 2806      jr      z,$d533          ; (+$06)
d52d cdb9ce    call    $ceb9
d530 cdbece    call    $cebe
d533 cd9ddb    call    $db9d
d536 cd0bcf    call    $cf0b
d539 cdc7dc    call    $dcc7
d53c 3e0c      ld      a,$0c
d53e cd69d5    call    $d569
d541 65        ld      h,l
d542 e5        push    hl
d543 cd7bd7    call    $d77b
d546 cd90d7    call    $d790
d549 301a      jr      nc,$d565         ; (+$1a)
d54b cdd6da    call    $dad6
d54e 38f6      jr      c,$d546          ; (-$0a)
d550 e3        ex      (sp),hl
d551 c5        push    bc
d552 7c        ld      a,h
d553 bd        cp      l
d554 c4bbdc    call    nz,$dcbb
d557 cc4fcb    call    z,$cb4f
d55a cdbfdc    call    $dcbf
d55d 2d        dec     l
d55e 2001      jr      nz,$d561         ; (+$01)
d560 6c        ld      l,h
d561 c1        pop     bc
d562 e3        ex      (sp),hl
d563 18e1      jr      $d546            ; (-$1f)
d565 e1        pop     hl
d566 c368d6    jp      $d668
d569 c603      add     a,$03
d56b 67        ld      h,a
d56c d5        push    de
d56d e5        push    hl
d56e cd69bb    call    $bb69
d571 7a        ld      a,d
d572 e1        pop     hl
d573 d1        pop     de
d574 c604      add     a,$04
d576 2e00      ld      l,$00
d578 2c        inc     l
d579 94        sub     h
d57a 30fc      jr      nc,$d578         ; (-$04)
d57c 2d        dec     l
d57d c0        ret     nz

d57e 2e01      ld      l,$01
d580 c9        ret     

d581 cd6ace    call    $ce6a
d584 cdb9ce    call    $ceb9
d587 cdbece    call    $cebe
d58a cd84db    call    $db84
d58d cd0bcf    call    $cf0b
d590 cd7bd7    call    $d77b
d593 cd90d7    call    $d790
d596 306b      jr      nc,$d603         ; (+$6b)
d598 cda8d5    call    $d5a8
d59b cd90d7    call    $d790
d59e 38f8      jr      c,$d598          ; (-$08)
d5a0 c9        ret     

d5a1 cda8d5    call    $d5a8
d5a4 d2afce    jp      nc,$ceaf
d5a7 c9        ret     

d5a8 cdd0da    call    $dad0
d5ab 3f        ccf     
d5ac 3e0a      ld      a,$0a
d5ae d2c1dc    jp      nc,$dcc1
d5b1 af        xor     a
d5b2 cd33d9    call    $d933
d5b5 3ee5      ld      a,$e5
d5b7 12        ld      (de),a
d5b8 c371da    jp      $da71
d5bb cd6ace    call    $ce6a
d5be cdb8ce    call    $ceb8
d5c1 cdbece    call    $cebe
d5c4 cd52db    call    $db52
d5c7 c5        push    bc
d5c8 cdbece    call    $cebe
d5cb cd57db    call    $db57
d5ce e1        pop     hl
d5cf 0a        ld      a,(bc)
d5d0 be        cp      (hl)
d5d1 c2a6ce    jp      nz,$cea6
d5d4 cd0bcf    call    $cf0b
d5d7 23        inc     hl
d5d8 e5        push    hl
d5d9 cd3cd7    call    $d73c
d5dc e1        pop     hl
d5dd c5        push    bc
d5de 44        ld      b,h
d5df 4d        ld      c,l
d5e0 cd7bd7    call    $d77b
d5e3 cd90d7    call    $d790
d5e6 301b      jr      nc,$d603         ; (+$1b)
d5e8 cdd0da    call    $dad0
d5eb da84d4    jp      c,$d484
d5ee e3        ex      (sp),hl
d5ef e5        push    hl
d5f0 c5        push    bc
d5f1 010c00    ld      bc,$000c
d5f4 edb0      ldir    
d5f6 c1        pop     bc
d5f7 e1        pop     hl
d5f8 e3        ex      (sp),hl
d5f9 cd71da    call    $da71
d5fc cd90d7    call    $d790
d5ff 38e7      jr      c,$d5e8          ; (-$19)
d601 e1        pop     hl
d602 c9        ret     

d603 50        ld      d,b
d604 59        ld      e,c
d605 3e06      ld      a,$06
d607 c3a8ce    jp      $cea8
d60a cd6ace    call    $ce6a
d60d d5        push    de
d60e dde1      pop     ix
d610 010008    ld      bc,$0800
d613 cd15cb    call    $cb15			;; clear block
d616 cd7ddb    call    $db7d
d619 cd0bcf    call    $cf0b
d61c cdc7dc    call    $dcc7
d61f af        xor     a
d620 f5        push    af
d621 cd7bd7    call    $d77b
d624 cd90d7    call    $d790
d627 300c      jr      nc,$d635         ; (+$0c)
d629 cdd6da    call    $dad6
d62c 38f6      jr      c,$d624          ; (-$0a)
d62e e3        ex      (sp),hl
d62f cda2d6    call    $d6a2
d632 e3        ex      (sp),hl
d633 38ef      jr      c,$d624          ; (-$11)
d635 3e11      ld      a,$11
d637 cd69d5    call    $d569
d63a 55        ld      d,l
d63b f1        pop     af
d63c 1e00      ld      e,$00
d63e 1c        inc     e
d63f 92        sub     d
d640 30fc      jr      nc,$d63e         ; (-$04)
d642 82        add     a,d
d643 2001      jr      nz,$d646         ; (+$01)
d645 1d        dec     e
d646 dde5      push    ix
d648 e1        pop     hl
d649 4b        ld      c,e
d64a 42        ld      b,d
d64b e5        push    hl
d64c cd72d6    call    $d672
d64f d5        push    de
d650 eb        ex      de,hl
d651 2600      ld      h,$00
d653 cd32d7    call    $d732
d656 19        add     hl,de
d657 d1        pop     de
d658 10f2      djnz    $d64c            ; (-$0e)
d65a e1        pop     hl
d65b d5        push    de
d65c 110e00    ld      de,$000e
d65f 19        add     hl,de
d660 d1        pop     de
d661 0d        dec     c
d662 2804      jr      z,$d668          ; (+$04)
d664 e7        rst     $20
d665 b7        or      a
d666 20e2      jr      nz,$d64a         ; (-$1e)
d668 cdb9d9    call    $d9b9
d66b 3e03      ld      a,$03
d66d b7        or      a
d66e 37        scf     
d66f c351cb    jp      $cb51
d672 e7        rst     $20
d673 b7        or      a
d674 c8        ret     z

d675 e5        push    hl
d676 d5        push    de
d677 c5        push    bc
d678 78        ld      a,b
d679 ba        cp      d
d67a c4bbdc    call    nz,$dcbb
d67d cc4fcb    call    z,$cb4f
d680 eb        ex      de,hl
d681 cdbfdc    call    $dcbf
d684 cdd0da    call    $dad0
d687 3e2a      ld      a,$2a
d689 3802      jr      c,$d68d          ; (+$02)
d68b 3e20      ld      a,$20
d68d cd5abb    call    $bb5a
d690 210c00    ld      hl,$000c
d693 19        add     hl,de
d694 e7        rst     $20
d695 5f        ld      e,a
d696 23        inc     hl
d697 e7        rst     $20
d698 57        ld      d,a
d699 3e02      ld      a,$02
d69b cd51cb    call    $cb51
d69e c1        pop     bc
d69f d1        pop     de
d6a0 e1        pop     hl
d6a1 c9        ret     

d6a2 c5        push    bc
d6a3 4c        ld      c,h
d6a4 0600      ld      b,$00
d6a6 dde5      push    ix
d6a8 e1        pop     hl
d6a9 e7        rst     $20
d6aa b7        or      a
d6ab 2850      jr      z,$d6fd          ; (+$50)
d6ad 04        inc     b
d6ae cd1bd7    call    $d71b
d6b1 280f      jr      z,$d6c2          ; (+$0f)
d6b3 3026      jr      nc,$d6db         ; (+$26)
d6b5 d5        push    de
d6b6 110e00    ld      de,$000e
d6b9 19        add     hl,de
d6ba d1        pop     de
d6bb 78        ld      a,b
d6bc fe92      cp      $92
d6be 38e9      jr      c,$d6a9          ; (-$17)
d6c0 1856      jr      $d718            ; (+$56)
d6c2 e5        push    hl
d6c3 cde9d9    call    $d9e9
d6c6 e3        ex      (sp),hl
d6c7 110c00    ld      de,$000c
d6ca 19        add     hl,de
d6cb e7        rst     $20
d6cc 5f        ld      e,a
d6cd 23        inc     hl
d6ce e7        rst     $20
d6cf 57        ld      d,a
d6d0 2b        dec     hl
d6d1 e3        ex      (sp),hl
d6d2 19        add     hl,de
d6d3 eb        ex      de,hl
d6d4 e1        pop     hl
d6d5 73        ld      (hl),e
d6d6 23        inc     hl
d6d7 72        ld      (hl),d
d6d8 37        scf     
d6d9 183d      jr      $d718            ; (+$3d)
d6db 79        ld      a,c
d6dc fe92      cp      $92
d6de 2838      jr      z,$d718          ; (+$38)
d6e0 e5        push    hl
d6e1 d5        push    de
d6e2 c5        push    bc
d6e3 eb        ex      de,hl
d6e4 79        ld      a,c
d6e5 90        sub     b
d6e6 3c        inc     a
d6e7 6f        ld      l,a
d6e8 2600      ld      h,$00
d6ea cd32d7    call    $d732
d6ed 44        ld      b,h
d6ee 4d        ld      c,l
d6ef 19        add     hl,de
d6f0 2b        dec     hl
d6f1 eb        ex      de,hl
d6f2 210e00    ld      hl,$000e
d6f5 19        add     hl,de
d6f6 eb        ex      de,hl
d6f7 cd1eb9    call    $b91e
d6fa c1        pop     bc
d6fb d1        pop     de
d6fc e1        pop     hl
d6fd 0c        inc     c
d6fe c5        push    bc
d6ff d5        push    de
d700 36ff      ld      (hl),$ff
d702 23        inc     hl
d703 13        inc     de
d704 eb        ex      de,hl
d705 010b00    ld      bc,$000b
d708 cd1bb9    call    $b91b
d70b eb        ex      de,hl
d70c e3        ex      (sp),hl
d70d eb        ex      de,hl
d70e cde9d9    call    $d9e9
d711 eb        ex      de,hl
d712 e1        pop     hl
d713 73        ld      (hl),e
d714 23        inc     hl
d715 72        ld      (hl),d
d716 c1        pop     bc
d717 37        scf     
d718 61        ld      h,c
d719 c1        pop     bc
d71a c9        ret     

d71b e5        push    hl
d71c d5        push    de
d71d c5        push    bc
d71e 060b      ld      b,$0b
d720 13        inc     de
d721 23        inc     hl
d722 1a        ld      a,(de)
d723 e67f      and     $7f
d725 4f        ld      c,a
d726 e7        rst     $20
d727 e67f      and     $7f
d729 b9        cp      c
d72a 2002      jr      nz,$d72e         ; (+$02)
d72c 10f2      djnz    $d720            ; (-$0e)
d72e c1        pop     bc
d72f d1        pop     de
d730 e1        pop     hl
d731 c9        ret     

d732 d5        push    de
d733 54        ld      d,h
d734 5d        ld      e,l
d735 29        add     hl,hl
d736 19        add     hl,de
d737 29        add     hl,hl
d738 19        add     hl,de
d739 29        add     hl,hl
d73a d1        pop     de
d73b c9        ret     

d73c cd7bd7    call    $d77b
d73f cd90d7    call    $d790
d742 3025      jr      nc,$d769         ; (+$25)
d744 3e05      ld      a,$05
d746 c3a8ce    jp      $cea8
d749 cd7bd7    call    $d77b
d74c cd90d7    call    $d790
d74f 3018      jr      nc,$d769         ; (+$18)
d751 e5        push    hl
d752 210900    ld      hl,$0009
d755 cd05cb    call    $cb05			;; HL = HL + IY
d758 eb        ex      de,hl
d759 cdd6dc    call    $dcd6
d75c e1        pop     hl
d75d fd7e05    ld      a,(iy+$05)
d760 b7        or      a
d761 37        scf     
d762 c0        ret     nz

d763 cd9ad7    call    $d79a
d766 38fb      jr      c,$d763          ; (-$05)
d768 37        scf     
d769 fd3605ff  ld      (iy+$05),$ff
d76d c9        ret     

d76e cd7bd7    call    $d77b
d771 cd90d7    call    $d790
d774 30f3      jr      nc,$d769         ; (-$0d)
d776 cda1d5    call    $d5a1
d779 18f6      jr      $d771            ; (-$0a)
d77b c5        push    bc
d77c cd1fc5    call    $c51f
d77f c1        pop     bc
d780 21ffff    ld      hl,$ffff
d783 fd7e05    ld      a,(iy+$05)
d786 b7        or      a
d787 c0        ret     nz

d788 e5        push    hl
d789 cd0bd9    call    $d90b
d78c e1        pop     hl
d78d c39fda    jp      $da9f
d790 cd9ad7    call    $d79a
d793 d0        ret     nc

d794 cdcfd8    call    $d8cf
d797 30f7      jr      nc,$d790         ; (-$09)
d799 c9        ret     

d79a 23        inc     hl
d79b fd7e05    ld      a,(iy+$05)
d79e b7        or      a
d79f 2011      jr      nz,$d7b2         ; (+$11)
d7a1 cd13da    call    $da13
d7a4 d0        ret     nc

d7a5 1a        ld      a,(de)
d7a6 fee5      cp      $e5
d7a8 37        scf     
d7a9 c8        ret     z

d7aa cd9fda    call    $da9f
d7ad 3eff      ld      a,$ff
d7af c333d9    jp      $d933
d7b2 cdafda    call    $daaf
d7b5 d0        ret     nc

d7b6 c313da    jp      $da13
d7b9 212100    ld      hl,$0021
d7bc 19        add     hl,de
d7bd c3f0dc    jp      $dcf0
d7c0 212300    ld      hl,$0023
d7c3 19        add     hl,de
d7c4 7e        ld      a,(hl)
d7c5 b7        or      a
d7c6 c0        ret     nz

d7c7 cdb9d7    call    $d7b9
d7ca 7c        ld      a,h
d7cb 1f        rra     
d7cc 1f        rra     
d7cd 1f        rra     
d7ce 1f        rra     
d7cf e60f      and     $0f
d7d1 47        ld      b,a
d7d2 29        add     hl,hl
d7d3 7c        ld      a,h
d7d4 e61f      and     $1f
d7d6 4f        ld      c,a
d7d7 c5        push    bc
d7d8 210f00    ld      hl,$000f
d7db 19        add     hl,de
d7dc 7e        ld      a,(hl)
d7dd a8        xor     b
d7de 200f      jr      nz,$d7ef         ; (+$0f)
d7e0 3e04      ld      a,$04
d7e2 cd4bdb    call    $db4b
d7e5 2f        cpl     
d7e6 47        ld      b,a
d7e7 2b        dec     hl
d7e8 2b        dec     hl
d7e9 7e        ld      a,(hl)
d7ea a9        xor     c
d7eb a0        and     b
d7ec 2001      jr      nz,$d7ef         ; (+$01)
d7ee 37        scf     
d7ef c1        pop     bc
d7f0 9f        sbc     a,a
d7f1 c9        ret     

d7f2 210d00    ld      hl,$000d
d7f5 19        add     hl,de
d7f6 71        ld      (hl),c
d7f7 23        inc     hl
d7f8 23        inc     hl
d7f9 70        ld      (hl),b
d7fa 23        inc     hl
d7fb eb        ex      de,hl
d7fc 011100    ld      bc,$0011
d7ff cd15cb    call    $cb15				;; clear block
d802 eb        ex      de,hl
d803 c9        ret     

d804 d5        push    de
d805 cdb9d7    call    $d7b9
d808 7c        ld      a,h
d809 e60f      and     $0f
d80b 67        ld      h,a
d80c e5        push    hl
d80d 211000    ld      hl,$0010
d810 19        add     hl,de
d811 4e        ld      c,(hl)
d812 0600      ld      b,$00
d814 2b        dec     hl
d815 2b        dec     hl
d816 2b        dec     hl
d817 66        ld      h,(hl)
d818 68        ld      l,b
d819 cb3c      srl     h
d81b cb1d      rr      l
d81d 09        add     hl,bc
d81e d1        pop     de
d81f 13        inc     de
d820 cdeadc    call    $dcea
d823 3f        ccf     
d824 d1        pop     de
d825 c9        ret     

d826 cdb9d7    call    $d7b9
d829 3e03      ld      a,$03
d82b cd4bdb    call    $db4b
d82e a5        and     l
d82f 4f        ld      c,a
d830 3e02      ld      a,$02
d832 cd4bdb    call    $db4b
d835 cde2dc    call    $dce2
d838 3e06      ld      a,$06
d83a cd4bdb    call    $db4b
d83d 47        ld      b,a
d83e b7        or      a
d83f 7d        ld      a,l
d840 211100    ld      hl,$0011
d843 19        add     hl,de
d844 280e      jr      z,$d854          ; (+$0e)
d846 e607      and     $07
d848 87        add     a,a
d849 85        add     a,l
d84a 6f        ld      l,a
d84b 8c        adc     a,h
d84c 95        sub     l
d84d 67        ld      h,a
d84e e5        push    hl
d84f cdf0dc    call    $dcf0
d852 180b      jr      $d85f            ; (+$0b)
d854 e60f      and     $0f
d856 85        add     a,l
d857 6f        ld      l,a
d858 8c        adc     a,h
d859 95        sub     l
d85a 67        ld      h,a
d85b e5        push    hl
d85c 6e        ld      l,(hl)
d85d 2600      ld      h,$00
d85f 7c        ld      a,h
d860 b5        or      l
d861 280f      jr      z,$d872          ; (+$0f)
d863 f1        pop     af
d864 3e02      ld      a,$02
d866 cd4bdb    call    $db4b
d869 29        add     hl,hl
d86a 3d        dec     a
d86b 20fc      jr      nz,$d869         ; (-$04)
d86d 79        ld      a,c
d86e b5        or      l
d86f 6f        ld      l,a
d870 37        scf     
d871 c9        ret     

d872 e1        pop     hl
d873 c9        ret     

d874 211000    ld      hl,$0010
d877 19        add     hl,de
d878 7e        ld      a,(hl)
d879 34        inc     (hl)
d87a b7        or      a
d87b f0        ret     p

d87c 3601      ld      (hl),$01
d87e 2b        dec     hl
d87f 2b        dec     hl
d880 2b        dec     hl
d881 34        inc     (hl)
d882 c9        ret     

d883 d5        push    de
d884 d5        push    de
d885 cdb2d8    call    $d8b2
d888 e3        ex      (sp),hl
d889 23        inc     hl
d88a cdd6dc    call    $dcd6
d88d e1        pop     hl
d88e cd71da    call    $da71
d891 d1        pop     de
d892 c9        ret     

d893 212100    ld      hl,$0021
d896 19        add     hl,de
d897 af        xor     a
d898 77        ld      (hl),a
d899 23        inc     hl
d89a 77        ld      (hl),a
d89b 23        inc     hl
d89c 77        ld      (hl),a
d89d c9        ret     

d89e 212100    ld      hl,$0021
d8a1 19        add     hl,de
d8a2 34        inc     (hl)
d8a3 c0        ret     nz

d8a4 23        inc     hl
d8a5 34        inc     (hl)
d8a6 c0        ret     nz

d8a7 23        inc     hl
d8a8 34        inc     (hl)
d8a9 c9        ret     

d8aa cd7bd7    call    $d77b
d8ad cd90d7    call    $d790
d8b0 1811      jr      $d8c3            ; (+$11)
d8b2 21ffff    ld      hl,$ffff
d8b5 23        inc     hl
d8b6 cd13da    call    $da13
d8b9 3e07      ld      a,$07
d8bb d2a8ce    jp      nc,$cea8
d8be 1a        ld      a,(de)
d8bf fee5      cp      $e5
d8c1 20f2      jr      nz,$d8b5         ; (-$0e)
d8c3 f5        push    af
d8c4 fd7e05    ld      a,(iy+$05)
d8c7 b7        or      a
d8c8 3e09      ld      a,$09
d8ca caafce    jp      z,$ceaf
d8cd f1        pop     af
d8ce c9        ret     

d8cf c5        push    bc
d8d0 d5        push    de
d8d1 e5        push    hl
d8d2 60        ld      h,b
d8d3 69        ld      l,c
d8d4 1a        ld      a,(de)
d8d5 ae        xor     (hl)
d8d6 202d      jr      nz,$d905         ; (+$2d)
d8d8 23        inc     hl
d8d9 13        inc     de
d8da 060b      ld      b,$0b
d8dc 7e        ld      a,(hl)
d8dd fe3f      cp      $3f
d8df 2806      jr      z,$d8e7          ; (+$06)
d8e1 1a        ld      a,(de)
d8e2 ae        xor     (hl)
d8e3 e67f      and     $7f
d8e5 201e      jr      nz,$d905         ; (+$1e)
d8e7 23        inc     hl
d8e8 13        inc     de
d8e9 10f1      djnz    $d8dc            ; (-$0f)
d8eb 7e        ld      a,(hl)
d8ec 3c        inc     a
d8ed 280c      jr      z,$d8fb          ; (+$0c)
d8ef 3e04      ld      a,$04
d8f1 cd4bdb    call    $db4b
d8f4 2f        cpl     
d8f5 47        ld      b,a
d8f6 1a        ld      a,(de)
d8f7 ae        xor     (hl)
d8f8 a0        and     b
d8f9 200a      jr      nz,$d905         ; (+$0a)
d8fb 23        inc     hl
d8fc 13        inc     de
d8fd 23        inc     hl
d8fe 13        inc     de
d8ff 7e        ld      a,(hl)
d900 3c        inc     a
d901 2802      jr      z,$d905          ; (+$02)
d903 1a        ld      a,(de)
d904 ae        xor     (hl)
d905 e1        pop     hl
d906 d1        pop     de
d907 c1        pop     bc
d908 c0        ret     nz

d909 37        scf     
d90a c9        ret     

d90b 3e05      ld      a,$05
d90d cd3cdb    call    $db3c
d910 3e03      ld      a,$03
d912 cde2dc    call    $dce2
d915 23        inc     hl
d916 eb        ex      de,hl
d917 3e0e      ld      a,$0e
d919 cd36db    call    $db36
d91c 3600      ld      (hl),$00
d91e 23        inc     hl
d91f 1b        dec     de
d920 7a        ld      a,d
d921 b3        or      e
d922 20f8      jr      nz,$d91c         ; (-$08)
d924 3e09      ld      a,$09
d926 cd3cdb    call    $db3c
d929 eb        ex      de,hl
d92a 3e0e      ld      a,$0e
d92c cd36db    call    $db36
d92f 73        ld      (hl),e
d930 23        inc     hl
d931 72        ld      (hl),d
d932 c9        ret     

d933 e5        push    hl
d934 d5        push    de
d935 c5        push    bc
d936 4f        ld      c,a
d937 211000    ld      hl,$0010
d93a 19        add     hl,de
d93b 0610      ld      b,$10
d93d 5e        ld      e,(hl)
d93e 23        inc     hl
d93f 3e06      ld      a,$06
d941 cd4bdb    call    $db4b
d944 b7        or      a
d945 2803      jr      z,$d94a          ; (+$03)
d947 05        dec     b
d948 7e        ld      a,(hl)
d949 23        inc     hl
d94a 57        ld      d,a
d94b b3        or      e
d94c 280e      jr      z,$d95c          ; (+$0e)
d94e e5        push    hl
d94f 3e05      ld      a,$05
d951 cd3cdb    call    $db3c
d954 7d        ld      a,l
d955 93        sub     e
d956 7c        ld      a,h
d957 9a        sbc     a,d
d958 d463d9    call    nc,$d963
d95b e1        pop     hl
d95c 10df      djnz    $d93d            ; (-$21)
d95e c1        pop     bc
d95f d1        pop     de
d960 e1        pop     hl
d961 37        scf     
d962 c9        ret     

d963 c5        push    bc
d964 d5        push    de
d965 d5        push    de
d966 eb        ex      de,hl
d967 3e03      ld      a,$03
d969 cde2dc    call    $dce2
d96c eb        ex      de,hl
d96d 3e0e      ld      a,$0e
d96f cd36db    call    $db36
d972 19        add     hl,de
d973 d1        pop     de
d974 7b        ld      a,e
d975 e607      and     $07
d977 5f        ld      e,a
d978 3e01      ld      a,$01
d97a 1c        inc     e
d97b 0f        rrca    
d97c 1d        dec     e
d97d 20fc      jr      nz,$d97b         ; (-$04)
d97f 47        ld      b,a
d980 a1        and     c
d981 4f        ld      c,a
d982 78        ld      a,b
d983 2f        cpl     
d984 a6        and     (hl)
d985 b1        or      c
d986 77        ld      (hl),a
d987 d1        pop     de
d988 c1        pop     bc
d989 c9        ret     

d98a c5        push    bc
d98b d5        push    de
d98c 3e05      ld      a,$05
d98e cd3cdb    call    $db3c
d991 eb        ex      de,hl
d992 3e0e      ld      a,$0e
d994 cd36db    call    $db36
d997 018008    ld      bc,$0880
d99a 7e        ld      a,(hl)
d99b a1        and     c
d99c 280c      jr      z,$d9aa          ; (+$0c)
d99e 0f        rrca    
d99f 4f        ld      c,a
d9a0 7a        ld      a,d
d9a1 b3        or      e
d9a2 2812      jr      z,$d9b6          ; (+$12)
d9a4 1b        dec     de
d9a5 10f3      djnz    $d99a            ; (-$0d)
d9a7 23        inc     hl
d9a8 18ed      jr      $d997            ; (-$13)
d9aa 7e        ld      a,(hl)
d9ab b1        or      c
d9ac 77        ld      (hl),a
d9ad 3e05      ld      a,$05
d9af cd3cdb    call    $db3c
d9b2 b7        or      a
d9b3 ed52      sbc     hl,de
d9b5 37        scf     
d9b6 d1        pop     de
d9b7 c1        pop     bc
d9b8 c9        ret     

d9b9 c5        push    bc
d9ba e5        push    hl
d9bb 210000    ld      hl,$0000
d9be e5        push    hl
d9bf 3e05      ld      a,$05
d9c1 cd3cdb    call    $db3c
d9c4 eb        ex      de,hl
d9c5 3e0e      ld      a,$0e
d9c7 cd36db    call    $db36
d9ca 018008    ld      bc,$0880
d9cd 7e        ld      a,(hl)
d9ce a1        and     c
d9cf 2003      jr      nz,$d9d4         ; (+$03)
d9d1 e3        ex      (sp),hl
d9d2 23        inc     hl
d9d3 e3        ex      (sp),hl
d9d4 79        ld      a,c
d9d5 0f        rrca    
d9d6 4f        ld      c,a
d9d7 7a        ld      a,d
d9d8 b3        or      e
d9d9 2806      jr      z,$d9e1          ; (+$06)
d9db 1b        dec     de
d9dc 10ef      djnz    $d9cd            ; (-$11)
d9de 23        inc     hl
d9df 18e9      jr      $d9ca            ; (-$17)
d9e1 e1        pop     hl
d9e2 cd07da    call    $da07
d9e5 eb        ex      de,hl
d9e6 e1        pop     hl
d9e7 c1        pop     bc
d9e8 c9        ret     

d9e9 d5        push    de
d9ea 211000    ld      hl,$0010
d9ed 19        add     hl,de
d9ee 110010    ld      de,$1000
d9f1 3e06      ld      a,$06
d9f3 cd4bdb    call    $db4b
d9f6 b7        or      a
d9f7 7e        ld      a,(hl)
d9f8 23        inc     hl
d9f9 2803      jr      z,$d9fe          ; (+$03)
d9fb b6        or      (hl)
d9fc 15        dec     d
d9fd 23        inc     hl
d9fe b7        or      a
d9ff 2801      jr      z,$da02          ; (+$01)
da01 1c        inc     e
da02 15        dec     d
da03 20ec      jr      nz,$d9f1         ; (-$14)
da05 eb        ex      de,hl
da06 d1        pop     de
da07 3e02      ld      a,$02
da09 cd4bdb    call    $db4b
da0c 3d        dec     a
da0d 3d        dec     a
da0e 3d        dec     a
da0f c8        ret     z

da10 29        add     hl,hl
da11 18fb      jr      $da0e            ; (-$05)
da13 e5        push    hl
da14 c5        push    bc
da15 7d        ld      a,l
da16 e603      and     $03
da18 2011      jr      nz,$da2b         ; (+$11)
da1a eb        ex      de,hl
da1b 3e07      ld      a,$07
da1d cd3cdb    call    $db3c
da20 cdeadc    call    $dcea
da23 3f        ccf     
da24 eb        ex      de,hl
da25 3015      jr      nc,$da3c         ; (+$15)
da27 cd3fda    call    $da3f
da2a af        xor     a
da2b 47        ld      b,a
da2c 3e08      ld      a,$08
da2e cd36db    call    $db36
da31 112000    ld      de,$0020
da34 04        inc     b
da35 1801      jr      $da38            ; (+$01)
da37 19        add     hl,de
da38 10fd      djnz    $da37            ; (-$03)
da3a eb        ex      de,hl
da3b 37        scf     
da3c c1        pop     bc
da3d e1        pop     hl
da3e c9        ret     

da3f 3e02      ld      a,$02
da41 cde2dc    call    $dce2
da44 eb        ex      de,hl
da45 3e08      ld      a,$08
da47 cd36db    call    $db36
da4a cddfda    call    $dadf
da4d 3e0b      ld      a,$0b
da4f cd3cdb    call    $db3c
da52 eb        ex      de,hl
da53 cdeadc    call    $dcea
da56 eb        ex      de,hl
da57 d0        ret     nc

da58 3e0c      ld      a,$0c
da5a cd36db    call    $db36
da5d 19        add     hl,de
da5e cdbfda    call    $dabf
da61 be        cp      (hl)
da62 c8        ret     z

da63 f5        push    af
da64 eb        ex      de,hl
da65 29        add     hl,hl
da66 29        add     hl,hl
da67 cdafda    call    $daaf
da6a eb        ex      de,hl
da6b d1        pop     de
da6c da2ad3    jp      c,$d32a
da6f 72        ld      (hl),d
da70 c9        ret     

da71 e5        push    hl
da72 c5        push    bc
da73 3e02      ld      a,$02
da75 cde2dc    call    $dce2
da78 eb        ex      de,hl
da79 3e08      ld      a,$08
da7b cd36db    call    $db36
da7e 0e01      ld      c,$01
da80 cdeada    call    $daea
da83 3e0b      ld      a,$0b
da85 cd3cdb    call    $db3c
da88 eb        ex      de,hl
da89 cdeadc    call    $dcea
da8c eb        ex      de,hl
da8d 300a      jr      nc,$da99         ; (+$0a)
da8f 3e0c      ld      a,$0c
da91 cd36db    call    $db36
da94 19        add     hl,de
da95 cdbfda    call    $dabf
da98 77        ld      (hl),a
da99 c1        pop     bc
da9a e1        pop     hl
da9b cdafda    call    $daaf
da9e d8        ret     c

da9f d5        push    de
daa0 e5        push    hl
daa1 eb        ex      de,hl
daa2 13        inc     de
daa3 3e02      ld      a,$02
daa5 cd2cdb    call    $db2c
daa8 73        ld      (hl),e
daa9 23        inc     hl
daaa 72        ld      (hl),d
daab e1        pop     hl
daac d1        pop     de
daad 37        scf     
daae c9        ret     

daaf d5        push    de
dab0 e5        push    hl
dab1 3e02      ld      a,$02
dab3 cd2cdb    call    $db2c
dab6 5e        ld      e,(hl)
dab7 23        inc     hl
dab8 56        ld      d,(hl)
dab9 e1        pop     hl
daba cdeadc    call    $dcea
dabd d1        pop     de
dabe c9        ret     

dabf c5        push    bc
dac0 e5        push    hl
dac1 0680      ld      b,$80
dac3 3e08      ld      a,$08
dac5 cd36db    call    $db36
dac8 af        xor     a
dac9 86        add     a,(hl)
daca 23        inc     hl
dacb 10fc      djnz    $dac9            ; (-$04)
dacd e1        pop     hl
dace c1        pop     bc
dacf c9        ret     

dad0 e5        push    hl
dad1 210900    ld      hl,$0009
dad4 1804      jr      $dada            ; (+$04)
dad6 e5        push    hl
dad7 210a00    ld      hl,$000a
dada 19        add     hl,de
dadb 7e        ld      a,(hl)
dadc 87        add     a,a
dadd e1        pop     hl
dade c9        ret     

dadf c5        push    bc
dae0 d5        push    de
dae1 e5        push    hl
dae2 cdfdda    call    $dafd
dae5 cd4cc5    call    $c54c
dae8 180b      jr      $daf5            ; (+$0b)
daea c5        push    bc
daeb d5        push    de
daec e5        push    hl
daed c5        push    bc
daee cdfdda    call    $dafd
daf1 c1        pop     bc
daf2 cd2ec5    call    $c52e
daf5 b7        or      a
daf6 c2adce    jp      nz,$cead
daf9 e1        pop     hl
dafa d1        pop     de
dafb c1        pop     bc
dafc c9        ret     

dafd d5        push    de
dafe 44        ld      b,h
daff 4d        ld      c,l
db00 cd1ac5    call    $c51a
db03 d1        pop     de
db04 3e0d      ld      a,$0d
db06 cd3cdb    call    $db3c
db09 44        ld      b,h
db0a 4d        ld      c,l
db0b af        xor     a
db0c cd3cdb    call    $db3c
db0f 0b        dec     bc
db10 03        inc     bc
db11 7b        ld      a,e
db12 95        sub     l
db13 5f        ld      e,a
db14 7a        ld      a,d
db15 9c        sbc     a,h
db16 57        ld      d,a
db17 30f7      jr      nc,$db10         ; (-$09)
db19 19        add     hl,de
db1a e5        push    hl
db1b cd24c5    call    $c524
db1e c1        pop     bc
db1f af        xor     a
db20 cd36db    call    $db36
db23 eb        ex      de,hl
db24 cd5ac5    call    $c55a
db27 4d        ld      c,l
db28 44        ld      b,h
db29 c329c5    jp      $c529
db2c fd8603    add     a,(iy+$03)
db2f 6f        ld      l,a
db30 fd8e04    adc     a,(iy+$04)
db33 95        sub     l
db34 67        ld      h,a
db35 c9        ret     

db36 cd2cdb    call    $db2c
db39 c3f0dc    jp      $dcf0
db3c f5        push    af
db3d 3e0a      ld      a,$0a
db3f cd36db    call    $db36
db42 f1        pop     af
db43 85        add     a,l
db44 6f        ld      l,a
db45 8c        adc     a,h
db46 95        sub     l
db47 67        ld      h,a
db48 c3f0dc    jp      $dcf0
db4b e5        push    hl
db4c cd3cdb    call    $db3c
db4f 7d        ld      a,l
db50 e1        pop     hl
db51 c9        ret     

db52 11e400    ld      de,$00e4
db55 1803      jr      $db5a            ; (+$03)
db57 11f400    ld      de,$00f4
db5a 0e20      ld      c,$20
db5c cd6bdb    call    $db6b
db5f 182b      jr      $db8c            ; (+$2b)
db61 cd66db    call    $db66
db64 1826      jr      $db8c            ; (+$26)
db66 0eff      ld      c,$ff
db68 11e400    ld      de,$00e4
db6b cd97db    call    $db97
db6e c5        push    bc
db6f 160b      ld      d,$0b
db71 03        inc     bc
db72 03        inc     bc
db73 0a        ld      a,(bc)
db74 fe3f      cp      $3f
db76 2869      jr      z,$dbe1          ; (+$69)
db78 15        dec     d
db79 20f7      jr      nz,$db72         ; (-$09)
db7b c1        pop     bc
db7c c9        ret     

db7d 0600      ld      b,$00
db7f cd9ddb    call    $db9d
db82 1808      jr      $db8c            ; (+$08)
db84 0e20      ld      c,$20
db86 11e400    ld      de,$00e4
db89 cd97db    call    $db97
db8c 210d00    ld      hl,$000d
db8f 09        add     hl,bc
db90 36ff      ld      (hl),$ff
db92 23        inc     hl
db93 23        inc     hl
db94 36ff      ld      (hl),$ff
db96 c9        ret     

db97 cdaddb    call    $dbad
db9a 2845      jr      z,$dbe1          ; (+$45)
db9c c9        ret     

db9d 0e20      ld      c,$20
db9f 11e400    ld      de,$00e4
dba2 cdaddb    call    $dbad
dba5 c5        push    bc
dba6 0e0b      ld      c,$0b
dba8 cc85dc    call    z,$dc85
dbab c1        pop     bc
dbac c9        ret     

dbad e5        push    hl
dbae cdfeca    call    $cafe
dbb1 d5        push    de
dbb2 fd7e00    ld      a,(iy+$00)
dbb5 12        ld      (de),a
dbb6 13        inc     de
dbb7 fd7e01    ld      a,(iy+$01)
dbba 12        ld      (de),a
dbbb 13        inc     de
dbbc c5        push    bc
dbbd 41        ld      b,c
dbbe 0e08      ld      c,$08
dbc0 cd7cdc    call    $dc7c
dbc3 78        ld      a,b
dbc4 0e03      ld      c,$03
dbc6 cd87dc    call    $dc87
dbc9 010300    ld      bc,$0003
dbcc cd15cb    call    $cb15				;; clear block
dbcf c1        pop     bc
dbd0 d1        pop     de
dbd1 e1        pop     hl
dbd2 d5        push    de
dbd3 cde4db    call    $dbe4
dbd6 d1        pop     de
dbd7 3008      jr      nc,$dbe1         ; (+$08)
dbd9 42        ld      b,d
dbda 4b        ld      c,e
dbdb 13        inc     de
dbdc 13        inc     de
dbdd 1a        ld      a,(de)
dbde fe20      cp      $20
dbe0 c9        ret     

dbe1 c3a6ce    jp      $cea6
dbe4 2b        dec     hl
dbe5 cd8edc    call    $dc8e
dbe8 3f        ccf     
dbe9 d8        ret     c

dbea 4f        ld      c,a
dbeb e5        push    hl
dbec c5        push    bc
dbed fe3a      cp      $3a
dbef 2806      jr      z,$dbf7          ; (+$06)
dbf1 cd9cdc    call    $dc9c
dbf4 38f7      jr      c,$dbed          ; (-$09)
dbf6 37        scf     
dbf7 c1        pop     bc
dbf8 e1        pop     hl
dbf9 79        ld      a,c
dbfa 383e      jr      c,$dc3a          ; (+$3e)
dbfc 13        inc     de
dbfd fe30      cp      $30
dbff 381f      jr      c,$dc20          ; (+$1f)
dc01 fe3a      cp      $3a
dc03 301b      jr      nc,$dc20         ; (+$1b)
dc05 d630      sub     $30
dc07 4f        ld      c,a
dc08 12        ld      (de),a
dc09 cd9cdc    call    $dc9c
dc0c fe30      cp      $30
dc0e 3810      jr      c,$dc20          ; (+$10)
dc10 fe3a      cp      $3a
dc12 300c      jr      nc,$dc20         ; (+$0c)
dc14 b7        or      a
dc15 0d        dec     c
dc16 c0        ret     nz

dc17 c6da      add     a,$da
dc19 fe10      cp      $10
dc1b d0        ret     nc

dc1c 12        ld      (de),a
dc1d cd9cdc    call    $dc9c
dc20 1b        dec     de
dc21 fe51      cp      $51
dc23 300a      jr      nc,$dc2f         ; (+$0a)
dc25 fe41      cp      $41
dc27 3806      jr      c,$dc2f          ; (+$06)
dc29 d641      sub     $41
dc2b 12        ld      (de),a
dc2c cd9cdc    call    $dc9c
dc2f cd92dc    call    $dc92
dc32 ee3a      xor     $3a
dc34 c0        ret     nz

dc35 cd8edc    call    $dc8e
dc38 3f        ccf     
dc39 d8        ret     c

dc3a 13        inc     de
dc3b 13        inc     de
dc3c fe2e      cp      $2e
dc3e c8        ret     z

dc3f 0e08      ld      c,$08
dc41 cd4fdc    call    $dc4f
dc44 d8        ret     c

dc45 ee2e      xor     $2e
dc47 c0        ret     nz

dc48 cd8edc    call    $dc8e
dc4b 0e03      ld      c,$03
dc4d 302d      jr      nc,$dc7c         ; (+$2d)
dc4f fe20      cp      $20
dc51 3829      jr      c,$dc7c          ; (+$29)
dc53 e5        push    hl
dc54 c5        push    bc
dc55 47        ld      b,a
dc56 21a9dc    ld      hl,$dca9
dc59 7e        ld      a,(hl)
dc5a 23        inc     hl
dc5b b7        or      a
dc5c 2804      jr      z,$dc62          ; (+$04)
dc5e b8        cp      b
dc5f 20f8      jr      nz,$dc59         ; (-$08)
dc61 37        scf     
dc62 78        ld      a,b
dc63 c1        pop     bc
dc64 e1        pop     hl
dc65 3815      jr      c,$dc7c          ; (+$15)
dc67 0d        dec     c
dc68 f8        ret     m

dc69 fe2a      cp      $2a
dc6b cc85dc    call    z,$dc85
dc6e 12        ld      (de),a
dc6f 13        inc     de
dc70 cd9cdc    call    $dc9c
dc73 3007      jr      nc,$dc7c         ; (+$07)
dc75 fe20      cp      $20
dc77 20d6      jr      nz,$dc4f         ; (-$2a)
dc79 cd92dc    call    $dc92
dc7c f5        push    af
dc7d 3e20      ld      a,$20
dc7f cd87dc    call    $dc87
dc82 f1        pop     af
dc83 3f        ccf     
dc84 c9        ret     

dc85 3e3f      ld      a,$3f
dc87 0c        inc     c
dc88 0d        dec     c
dc89 c8        ret     z

dc8a 12        ld      (de),a
dc8b 13        inc     de
dc8c 18fa      jr      $dc88            ; (-$06)
dc8e cd9cdc    call    $dc9c
dc91 d0        ret     nc

dc92 fe20      cp      $20
dc94 37        scf     
dc95 c0        ret     nz

dc96 cd9cdc    call    $dc9c
dc99 38f7      jr      c,$dc92          ; (-$09)
dc9b c9        ret     

dc9c 78        ld      a,b
dc9d b7        or      a
dc9e c8        ret     z

dc9f 23        inc     hl
dca0 05        dec     b
dca1 e7        rst     $20
dca2 e67f      and     $7f
dca4 cd0ccb    call    $cb0c			; convert to upper case
dca7 37        scf     
dca8 c9        ret     

dca9 3c        inc     a
dcaa 3e2e      ld      a,$2e
dcac 2c        inc     l
dcad 3b        dec     sp
dcae 3a3d5b    ld      a,($5b3d)
dcb1 5d        ld      e,l
dcb2 5f        ld      e,a
dcb3 25        dec     h
dcb4 7c        ld      a,h
dcb5 2829      jr      z,$dce0          ; (+$29)
dcb7 2f        cpl     
dcb8 5c        ld      e,h
dcb9 7f        ld      a,a
dcba 00        nop     
dcbb 3e01      ld      a,$01
dcbd 1802      jr      $dcc1            ; (+$02)
dcbf 3e0b      ld      a,$0b
dcc1 c5        push    bc
dcc2 fd4e02    ld      c,(iy+$02)
dcc5 180a      jr      $dcd1            ; (+$0a)
dcc7 c5        push    bc
dcc8 0a        ld      a,(bc)
dcc9 5f        ld      e,a
dcca 1600      ld      d,$00
dccc 0b        dec     bc
dccd 0a        ld      a,(bc)
dcce 4f        ld      c,a
dccf 3e0c      ld      a,$0c
dcd1 cd51cb    call    $cb51
dcd4 c1        pop     bc
dcd5 c9        ret     

dcd6 e5        push    hl
dcd7 d5        push    de
dcd8 c5        push    bc
dcd9 012000    ld      bc,$0020
dcdc edb0      ldir    
dcde c1        pop     bc
dcdf d1        pop     de
dce0 e1        pop     hl
dce1 c9        ret     

dce2 cb3c      srl     h
dce4 cb1d      rr      l
dce6 3d        dec     a
dce7 20f9      jr      nz,$dce2         ; (-$07)
dce9 c9        ret     

dcea e5        push    hl
dceb b7        or      a
dcec ed52      sbc     hl,de
dcee e1        pop     hl
dcef c9        ret     

dcf0 d5        push    de
dcf1 5e        ld      e,(hl)
dcf2 23        inc     hl
dcf3 56        ld      d,(hl)
dcf4 eb        ex      de,hl
dcf5 d1        pop     de
dcf6 c9        ret     

dcf7 c7        rst     $00
dcf8 c7        rst     $00
dcf9 c7        rst     $00
dcfa c7        rst     $00
dcfb c7        rst     $00
dcfc c7        rst     $00
dcfd c7        rst     $00
dcfe c7        rst     $00
dcff c7        rst     $00
dd00 c7        rst     $00
dd01 c7        rst     $00
dd02 c7        rst     $00
dd03 c7        rst     $00
dd04 c7        rst     $00
dd05 c7        rst     $00
dd06 c7        rst     $00
dd07 c7        rst     $00
dd08 c7        rst     $00
dd09 c7        rst     $00
dd0a c7        rst     $00
dd0b c7        rst     $00
dd0c c7        rst     $00
dd0d c7        rst     $00
dd0e c7        rst     $00
dd0f c7        rst     $00
dd10 c7        rst     $00
dd11 c7        rst     $00
dd12 c7        rst     $00
dd13 c7        rst     $00
dd14 c7        rst     $00
dd15 c7        rst     $00
dd16 c7        rst     $00
dd17 c7        rst     $00
dd18 c7        rst     $00
dd19 c7        rst     $00
dd1a c7        rst     $00
dd1b c7        rst     $00
dd1c c7        rst     $00
dd1d c7        rst     $00
dd1e c7        rst     $00
dd1f c7        rst     $00
dd20 c7        rst     $00
dd21 c7        rst     $00
dd22 c7        rst     $00
dd23 c7        rst     $00
dd24 c7        rst     $00
dd25 c7        rst     $00
dd26 c7        rst     $00
dd27 c7        rst     $00
dd28 c7        rst     $00
dd29 c7        rst     $00
dd2a c7        rst     $00
dd2b c7        rst     $00
dd2c c7        rst     $00
dd2d c7        rst     $00
dd2e c7        rst     $00
dd2f c7        rst     $00
dd30 c7        rst     $00
dd31 c7        rst     $00
dd32 c7        rst     $00
dd33 c7        rst     $00
dd34 c7        rst     $00
dd35 c7        rst     $00
dd36 c7        rst     $00
dd37 c7        rst     $00
dd38 c7        rst     $00
dd39 c7        rst     $00
dd3a c7        rst     $00
dd3b c7        rst     $00
dd3c c7        rst     $00
dd3d c7        rst     $00
dd3e c7        rst     $00
dd3f c7        rst     $00
dd40 c7        rst     $00
dd41 c7        rst     $00
dd42 c7        rst     $00
dd43 c7        rst     $00
dd44 c7        rst     $00
dd45 c7        rst     $00
dd46 c7        rst     $00
dd47 c7        rst     $00
dd48 c7        rst     $00
dd49 c7        rst     $00
dd4a c7        rst     $00
dd4b c7        rst     $00
dd4c c7        rst     $00
dd4d c7        rst     $00
dd4e c7        rst     $00
dd4f c7        rst     $00
dd50 c7        rst     $00
dd51 c7        rst     $00
dd52 c7        rst     $00
dd53 c7        rst     $00
dd54 c7        rst     $00
dd55 c7        rst     $00
dd56 c7        rst     $00
dd57 c7        rst     $00
dd58 c7        rst     $00
dd59 c7        rst     $00
dd5a c7        rst     $00
dd5b c7        rst     $00
dd5c c7        rst     $00
dd5d c7        rst     $00
dd5e c7        rst     $00
dd5f c7        rst     $00
dd60 c7        rst     $00
dd61 c7        rst     $00
dd62 c7        rst     $00
dd63 c7        rst     $00
dd64 c7        rst     $00
dd65 c7        rst     $00
dd66 c7        rst     $00
dd67 c7        rst     $00
dd68 c7        rst     $00
dd69 c7        rst     $00
dd6a c7        rst     $00
dd6b c7        rst     $00
dd6c c7        rst     $00
dd6d c7        rst     $00
dd6e c7        rst     $00
dd6f c7        rst     $00
dd70 c7        rst     $00
dd71 c7        rst     $00
dd72 c7        rst     $00
dd73 c7        rst     $00
dd74 c7        rst     $00
dd75 c7        rst     $00
dd76 c7        rst     $00
dd77 c7        rst     $00
dd78 c7        rst     $00
dd79 c7        rst     $00
dd7a c7        rst     $00
dd7b c7        rst     $00
dd7c c7        rst     $00
dd7d c7        rst     $00
dd7e c7        rst     $00
dd7f c7        rst     $00
dd80 c7        rst     $00
dd81 c7        rst     $00
dd82 c7        rst     $00
dd83 c7        rst     $00
dd84 c7        rst     $00
dd85 c7        rst     $00
dd86 c7        rst     $00
dd87 c7        rst     $00
dd88 c7        rst     $00
dd89 c7        rst     $00
dd8a c7        rst     $00
dd8b c7        rst     $00
dd8c c7        rst     $00
dd8d c7        rst     $00
dd8e c7        rst     $00
dd8f c7        rst     $00
dd90 c7        rst     $00
dd91 c7        rst     $00
dd92 c7        rst     $00
dd93 c7        rst     $00
dd94 c7        rst     $00
dd95 c7        rst     $00
dd96 c7        rst     $00
dd97 c7        rst     $00
dd98 c7        rst     $00
dd99 c7        rst     $00
dd9a c7        rst     $00
dd9b c7        rst     $00
dd9c c7        rst     $00
dd9d c7        rst     $00
dd9e c7        rst     $00
dd9f c7        rst     $00
dda0 c7        rst     $00
dda1 c7        rst     $00
dda2 c7        rst     $00
dda3 c7        rst     $00
dda4 c7        rst     $00
dda5 c7        rst     $00
dda6 c7        rst     $00
dda7 c7        rst     $00
dda8 c7        rst     $00
dda9 c7        rst     $00
ddaa c7        rst     $00
ddab c7        rst     $00
ddac c7        rst     $00
ddad c7        rst     $00
ddae c7        rst     $00
ddaf c7        rst     $00
ddb0 c7        rst     $00
ddb1 c7        rst     $00
ddb2 c7        rst     $00
ddb3 c7        rst     $00
ddb4 c7        rst     $00
ddb5 c7        rst     $00
ddb6 c7        rst     $00
ddb7 c7        rst     $00
ddb8 c7        rst     $00
ddb9 c7        rst     $00
ddba c7        rst     $00
ddbb c7        rst     $00
ddbc c7        rst     $00
ddbd c7        rst     $00
ddbe c7        rst     $00
ddbf c7        rst     $00
ddc0 c7        rst     $00
ddc1 c7        rst     $00
ddc2 c7        rst     $00
ddc3 c7        rst     $00
ddc4 c7        rst     $00
ddc5 c7        rst     $00
ddc6 c7        rst     $00
ddc7 c7        rst     $00
ddc8 c7        rst     $00
ddc9 c7        rst     $00
ddca c7        rst     $00
ddcb c7        rst     $00
ddcc c7        rst     $00
ddcd c7        rst     $00
ddce c7        rst     $00
ddcf c7        rst     $00
ddd0 c7        rst     $00
ddd1 c7        rst     $00
ddd2 c7        rst     $00
ddd3 c7        rst     $00
ddd4 c7        rst     $00
ddd5 c7        rst     $00
ddd6 c7        rst     $00
ddd7 c7        rst     $00
ddd8 c7        rst     $00
ddd9 c7        rst     $00
ddda c7        rst     $00
dddb c7        rst     $00
dddc c7        rst     $00
dddd c7        rst     $00
ddde c7        rst     $00
dddf c7        rst     $00
dde0 c7        rst     $00
dde1 c7        rst     $00
dde2 c7        rst     $00
dde3 c7        rst     $00
dde4 c7        rst     $00
dde5 c7        rst     $00
dde6 c7        rst     $00
dde7 c7        rst     $00
dde8 c7        rst     $00
dde9 c7        rst     $00
ddea c7        rst     $00
ddeb c7        rst     $00
ddec c7        rst     $00
dded c7        rst     $00
ddee c7        rst     $00
ddef c7        rst     $00
ddf0 c7        rst     $00
ddf1 c7        rst     $00
ddf2 c7        rst     $00
ddf3 c7        rst     $00
ddf4 c7        rst     $00
ddf5 c7        rst     $00
ddf6 c7        rst     $00
ddf7 c7        rst     $00
ddf8 c7        rst     $00
ddf9 c7        rst     $00
ddfa c7        rst     $00
ddfb c7        rst     $00
ddfc c7        rst     $00
ddfd c7        rst     $00
ddfe c7        rst     $00
ddff c7        rst     $00
de00 c7        rst     $00
de01 c7        rst     $00
de02 c7        rst     $00
de03 c7        rst     $00
de04 c7        rst     $00
de05 c7        rst     $00
de06 c7        rst     $00
de07 c7        rst     $00
de08 c7        rst     $00
de09 c7        rst     $00
de0a c7        rst     $00
de0b c7        rst     $00
de0c c7        rst     $00
de0d c7        rst     $00
de0e c7        rst     $00
de0f c7        rst     $00
de10 c7        rst     $00
de11 c7        rst     $00
de12 c7        rst     $00
de13 c7        rst     $00
de14 c7        rst     $00
de15 c7        rst     $00
de16 c7        rst     $00
de17 c7        rst     $00
de18 c7        rst     $00
de19 c7        rst     $00
de1a c7        rst     $00
de1b c7        rst     $00
de1c c7        rst     $00
de1d c7        rst     $00
de1e c7        rst     $00
de1f c7        rst     $00
de20 c7        rst     $00
de21 c7        rst     $00
de22 c7        rst     $00
de23 c7        rst     $00
de24 c7        rst     $00
de25 c7        rst     $00
de26 c7        rst     $00
de27 c7        rst     $00
de28 c7        rst     $00
de29 c7        rst     $00
de2a c7        rst     $00
de2b c7        rst     $00
de2c c7        rst     $00
de2d c7        rst     $00
de2e c7        rst     $00
de2f c7        rst     $00
de30 c7        rst     $00
de31 c7        rst     $00
de32 c7        rst     $00
de33 c7        rst     $00
de34 c7        rst     $00
de35 c7        rst     $00
de36 c7        rst     $00
de37 c7        rst     $00
de38 c7        rst     $00
de39 c7        rst     $00
de3a c7        rst     $00
de3b c7        rst     $00
de3c c7        rst     $00
de3d c7        rst     $00
de3e c7        rst     $00
de3f c7        rst     $00
de40 c7        rst     $00
de41 c7        rst     $00
de42 c7        rst     $00
de43 c7        rst     $00
de44 c7        rst     $00
de45 c7        rst     $00
de46 c7        rst     $00
de47 c7        rst     $00
de48 c7        rst     $00
de49 c7        rst     $00
de4a c7        rst     $00
de4b c7        rst     $00
de4c c7        rst     $00
de4d c7        rst     $00
de4e c7        rst     $00
de4f c7        rst     $00
de50 c7        rst     $00
de51 c7        rst     $00
de52 c7        rst     $00
de53 c7        rst     $00
de54 c7        rst     $00
de55 c7        rst     $00
de56 c7        rst     $00
de57 c7        rst     $00
de58 c7        rst     $00
de59 c7        rst     $00
de5a c7        rst     $00
de5b c7        rst     $00
de5c c7        rst     $00
de5d c7        rst     $00
de5e c7        rst     $00
de5f c7        rst     $00
de60 c7        rst     $00
de61 c7        rst     $00
de62 c7        rst     $00
de63 c7        rst     $00
de64 c7        rst     $00
de65 c7        rst     $00
de66 c7        rst     $00
de67 c7        rst     $00
de68 c7        rst     $00
de69 c7        rst     $00
de6a c7        rst     $00
de6b c7        rst     $00
de6c c7        rst     $00
de6d c7        rst     $00
de6e c7        rst     $00
de6f c7        rst     $00
de70 c7        rst     $00
de71 c7        rst     $00
de72 c7        rst     $00
de73 c7        rst     $00
de74 c7        rst     $00
de75 c7        rst     $00
de76 c7        rst     $00
de77 c7        rst     $00
de78 c7        rst     $00
de79 c7        rst     $00
de7a c7        rst     $00
de7b c7        rst     $00
de7c c7        rst     $00
de7d c7        rst     $00
de7e c7        rst     $00
de7f c7        rst     $00
de80 c7        rst     $00
de81 c7        rst     $00
de82 c7        rst     $00
de83 c7        rst     $00
de84 c7        rst     $00
de85 c7        rst     $00
de86 c7        rst     $00
de87 c7        rst     $00
de88 c7        rst     $00
de89 c7        rst     $00
de8a c7        rst     $00
de8b c7        rst     $00
de8c c7        rst     $00
de8d c7        rst     $00
de8e c7        rst     $00
de8f c7        rst     $00
de90 c7        rst     $00
de91 c7        rst     $00
de92 c7        rst     $00
de93 c7        rst     $00
de94 c7        rst     $00
de95 c7        rst     $00
de96 c7        rst     $00
de97 c7        rst     $00
de98 c7        rst     $00
de99 c7        rst     $00
de9a c7        rst     $00
de9b c7        rst     $00
de9c c7        rst     $00
de9d c7        rst     $00
de9e c7        rst     $00
de9f c7        rst     $00
dea0 c7        rst     $00
dea1 c7        rst     $00
dea2 c7        rst     $00
dea3 c7        rst     $00
dea4 c7        rst     $00
dea5 c7        rst     $00
dea6 c7        rst     $00
dea7 c7        rst     $00
dea8 c7        rst     $00
dea9 c7        rst     $00
deaa c7        rst     $00
deab c7        rst     $00
deac c7        rst     $00
dead c7        rst     $00
deae c7        rst     $00
deaf c7        rst     $00
deb0 c7        rst     $00
deb1 c7        rst     $00
deb2 c7        rst     $00
deb3 c7        rst     $00
deb4 c7        rst     $00
deb5 c7        rst     $00
deb6 c7        rst     $00
deb7 c7        rst     $00
deb8 c7        rst     $00
deb9 c7        rst     $00
deba c7        rst     $00
debb c7        rst     $00
debc c7        rst     $00
debd c7        rst     $00
debe c7        rst     $00
debf c7        rst     $00
dec0 c7        rst     $00
dec1 c7        rst     $00
dec2 c7        rst     $00
dec3 c7        rst     $00
dec4 c7        rst     $00
dec5 c7        rst     $00
dec6 c7        rst     $00
dec7 c7        rst     $00
dec8 c7        rst     $00
dec9 c7        rst     $00
deca c7        rst     $00
decb c7        rst     $00
decc c7        rst     $00
decd c7        rst     $00
dece c7        rst     $00
decf c7        rst     $00
ded0 c7        rst     $00
ded1 c7        rst     $00
ded2 c7        rst     $00
ded3 c7        rst     $00
ded4 c7        rst     $00
ded5 c7        rst     $00
ded6 c7        rst     $00
ded7 c7        rst     $00
ded8 c7        rst     $00
ded9 c7        rst     $00
deda c7        rst     $00
dedb c7        rst     $00
dedc c7        rst     $00
dedd c7        rst     $00
dede c7        rst     $00
dedf c7        rst     $00
dee0 c7        rst     $00
dee1 c7        rst     $00
dee2 c7        rst     $00
dee3 c7        rst     $00
dee4 c7        rst     $00
dee5 c7        rst     $00
dee6 c7        rst     $00
dee7 c7        rst     $00
dee8 c7        rst     $00
dee9 c7        rst     $00
deea c7        rst     $00
deeb c7        rst     $00
deec c7        rst     $00
deed c7        rst     $00
deee c7        rst     $00
deef c7        rst     $00
def0 c7        rst     $00
def1 c7        rst     $00
def2 c7        rst     $00
def3 c7        rst     $00
def4 c7        rst     $00
def5 c7        rst     $00
def6 c7        rst     $00
def7 c7        rst     $00
def8 c7        rst     $00
def9 c7        rst     $00
defa c7        rst     $00
defb c7        rst     $00
defc c7        rst     $00
defd c7        rst     $00
defe c7        rst     $00
deff c7        rst     $00
df00 c7        rst     $00
df01 c7        rst     $00
df02 c7        rst     $00
df03 c7        rst     $00
df04 c7        rst     $00
df05 c7        rst     $00
df06 c7        rst     $00
df07 c7        rst     $00
df08 c7        rst     $00
df09 c7        rst     $00
df0a c7        rst     $00
df0b c7        rst     $00
df0c c7        rst     $00
df0d c7        rst     $00
df0e c7        rst     $00
df0f c7        rst     $00
df10 c7        rst     $00
df11 c7        rst     $00
df12 c7        rst     $00
df13 c7        rst     $00
df14 c7        rst     $00
df15 c7        rst     $00
df16 c7        rst     $00
df17 c7        rst     $00
df18 c7        rst     $00
df19 c7        rst     $00
df1a c7        rst     $00
df1b c7        rst     $00
df1c c7        rst     $00
df1d c7        rst     $00
df1e c7        rst     $00
df1f c7        rst     $00
df20 c7        rst     $00
df21 c7        rst     $00
df22 c7        rst     $00
df23 c7        rst     $00
df24 c7        rst     $00
df25 c7        rst     $00
df26 c7        rst     $00
df27 c7        rst     $00
df28 c7        rst     $00
df29 c7        rst     $00
df2a c7        rst     $00
df2b c7        rst     $00
df2c c7        rst     $00
df2d c7        rst     $00
df2e c7        rst     $00
df2f c7        rst     $00
df30 c7        rst     $00
df31 c7        rst     $00
df32 c7        rst     $00
df33 c7        rst     $00
df34 c7        rst     $00
df35 c7        rst     $00
df36 c7        rst     $00
df37 c7        rst     $00
df38 c7        rst     $00
df39 c7        rst     $00
df3a c7        rst     $00
df3b c7        rst     $00
df3c c7        rst     $00
df3d c7        rst     $00
df3e c7        rst     $00
df3f c7        rst     $00
df40 c7        rst     $00
df41 c7        rst     $00
df42 c7        rst     $00
df43 c7        rst     $00
df44 c7        rst     $00
df45 c7        rst     $00
df46 c7        rst     $00
df47 c7        rst     $00
df48 c7        rst     $00
df49 c7        rst     $00
df4a c7        rst     $00
df4b c7        rst     $00
df4c c7        rst     $00
df4d c7        rst     $00
df4e c7        rst     $00
df4f c7        rst     $00
df50 c7        rst     $00
df51 c7        rst     $00
df52 c7        rst     $00
df53 c7        rst     $00
df54 c7        rst     $00
df55 c7        rst     $00
df56 c7        rst     $00
df57 c7        rst     $00
df58 c7        rst     $00
df59 c7        rst     $00
df5a c7        rst     $00
df5b c7        rst     $00
df5c c7        rst     $00
df5d c7        rst     $00
df5e c7        rst     $00
df5f c7        rst     $00
df60 c7        rst     $00
df61 c7        rst     $00
df62 c7        rst     $00
df63 c7        rst     $00
df64 c7        rst     $00
df65 c7        rst     $00
df66 c7        rst     $00
df67 c7        rst     $00
df68 c7        rst     $00
df69 c7        rst     $00
df6a c7        rst     $00
df6b c7        rst     $00
df6c c7        rst     $00
df6d c7        rst     $00
df6e c7        rst     $00
df6f c7        rst     $00
df70 c7        rst     $00
df71 c7        rst     $00
df72 c7        rst     $00
df73 c7        rst     $00
df74 c7        rst     $00
df75 c7        rst     $00
df76 c7        rst     $00
df77 c7        rst     $00
df78 c7        rst     $00
df79 c7        rst     $00
df7a c7        rst     $00
df7b c7        rst     $00
df7c c7        rst     $00
df7d c7        rst     $00
df7e c7        rst     $00
df7f c7        rst     $00
df80 c7        rst     $00
df81 c7        rst     $00
df82 c7        rst     $00
df83 c7        rst     $00
df84 c7        rst     $00
df85 c7        rst     $00
df86 c7        rst     $00
df87 c7        rst     $00
df88 c7        rst     $00
df89 c7        rst     $00
df8a c7        rst     $00
df8b c7        rst     $00
df8c c7        rst     $00
df8d c7        rst     $00
df8e c7        rst     $00
df8f c7        rst     $00
df90 c7        rst     $00
df91 c7        rst     $00
df92 c7        rst     $00
df93 c7        rst     $00
df94 c7        rst     $00
df95 c7        rst     $00
df96 c7        rst     $00
df97 c7        rst     $00
df98 c7        rst     $00
df99 c7        rst     $00
df9a c7        rst     $00
df9b c7        rst     $00
df9c c7        rst     $00
df9d c7        rst     $00
df9e c7        rst     $00
df9f c7        rst     $00
dfa0 c7        rst     $00
dfa1 c7        rst     $00
dfa2 c7        rst     $00
dfa3 c7        rst     $00
dfa4 c7        rst     $00
dfa5 c7        rst     $00
dfa6 c7        rst     $00
dfa7 c7        rst     $00
dfa8 c7        rst     $00
dfa9 c7        rst     $00
dfaa c7        rst     $00
dfab c7        rst     $00
dfac c7        rst     $00
dfad c7        rst     $00
dfae c7        rst     $00
dfaf c7        rst     $00
dfb0 c7        rst     $00
dfb1 c7        rst     $00
dfb2 c7        rst     $00
dfb3 c7        rst     $00
dfb4 c7        rst     $00
dfb5 c7        rst     $00
dfb6 c7        rst     $00
dfb7 c7        rst     $00
dfb8 c7        rst     $00
dfb9 c7        rst     $00
dfba c7        rst     $00
dfbb c7        rst     $00
dfbc c7        rst     $00
dfbd c7        rst     $00
dfbe c7        rst     $00
dfbf c7        rst     $00
dfc0 c7        rst     $00
dfc1 c7        rst     $00
dfc2 c7        rst     $00
dfc3 c7        rst     $00
dfc4 c7        rst     $00
dfc5 c7        rst     $00
dfc6 c7        rst     $00
dfc7 c7        rst     $00
dfc8 c7        rst     $00
dfc9 c7        rst     $00
dfca c7        rst     $00
dfcb c7        rst     $00
dfcc c7        rst     $00
dfcd c7        rst     $00
dfce c7        rst     $00
dfcf c7        rst     $00
dfd0 c7        rst     $00
dfd1 c7        rst     $00
dfd2 c7        rst     $00
dfd3 c7        rst     $00
dfd4 c7        rst     $00
dfd5 c7        rst     $00
dfd6 c7        rst     $00
dfd7 c7        rst     $00
dfd8 c7        rst     $00
dfd9 c7        rst     $00
dfda c7        rst     $00
dfdb c7        rst     $00
dfdc c7        rst     $00
dfdd c7        rst     $00
dfde c7        rst     $00
dfdf c7        rst     $00
dfe0 c7        rst     $00
dfe1 c7        rst     $00
dfe2 c7        rst     $00
dfe3 c7        rst     $00
dfe4 c7        rst     $00
dfe5 c7        rst     $00
dfe6 c7        rst     $00
dfe7 c7        rst     $00
dfe8 c7        rst     $00
dfe9 c7        rst     $00
dfea c7        rst     $00
dfeb c7        rst     $00
dfec c7        rst     $00
dfed c7        rst     $00
dfee c7        rst     $00
dfef c7        rst     $00
dff0 c7        rst     $00
dff1 c7        rst     $00
dff2 c7        rst     $00
dff3 c7        rst     $00
dff4 c7        rst     $00
dff5 c7        rst     $00
dff6 c7        rst     $00
dff7 c7        rst     $00
dff8 c7        rst     $00
dff9 c7        rst     $00
dffa c7        rst     $00
dffb c7        rst     $00
dffc c7        rst     $00
dffd c7        rst     $00
dffe c7        rst     $00
dfff c7        rst     $00
e000 rmem &1000,&ff				;; 4K of &ff
